/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.concurrent.atomic.AtomicLong;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.session.ActiveSessionStatistics;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.undertow.session.RecordableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;

public class DistributableSessionManagerStatistics
implements RecordableSessionManagerStatistics {
    private final RecordableInactiveSessionStatistics inactiveSessionStatistics;
    private final ActiveSessionStatistics activeSessionStatistics;
    private final Integer maxActiveSessions;
    private volatile long startTime = System.currentTimeMillis();
    private final AtomicLong createdSessionCount = new AtomicLong();

    public DistributableSessionManagerStatistics(ActiveSessionStatistics activeSessionStatistics, RecordableInactiveSessionStatistics inactiveSessionStatistics, Integer maxActiveSessions) {
        this.activeSessionStatistics = activeSessionStatistics;
        this.inactiveSessionStatistics = inactiveSessionStatistics;
        this.maxActiveSessions = maxActiveSessions;
        this.reset();
    }

    @Override
    public Recordable<ImmutableSessionMetaData> getInactiveSessionRecorder() {
        return this.inactiveSessionStatistics;
    }

    public void record(ImmutableSessionMetaData metaData) {
        this.createdSessionCount.incrementAndGet();
    }

    public void reset() {
        this.createdSessionCount.set(0L);
        this.startTime = System.currentTimeMillis();
        this.inactiveSessionStatistics.reset();
    }

    public long getCreatedSessionCount() {
        return this.createdSessionCount.get();
    }

    public long getMaxActiveSessions() {
        return this.maxActiveSessions != null ? this.maxActiveSessions.longValue() : -1L;
    }

    public long getActiveSessionCount() {
        return this.activeSessionStatistics.getActiveSessionCount();
    }

    public long getExpiredSessionCount() {
        return this.inactiveSessionStatistics.getExpiredSessionCount();
    }

    public long getRejectedSessions() {
        return 0L;
    }

    public long getMaxSessionAliveTime() {
        return this.inactiveSessionStatistics.getMaxSessionLifetime().toMillis();
    }

    public long getAverageSessionAliveTime() {
        return this.inactiveSessionStatistics.getMeanSessionLifetime().toMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

