/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.Functions;

public interface Dependency<B extends ServiceBuilder<?>, V>
extends Consumer<B>,
Supplier<V> {

    public static class DefaultDependency<B extends ServiceBuilder<?>, V>
    extends AbstractDependency<B, V> {
        private final ServiceName name;

        protected DefaultDependency(ServiceName name) {
            this.name = name;
        }

        @Override
        public Supplier<V> apply(B builder) {
            return builder.requires(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof DefaultDependency)) {
                return false;
            }
            return this.name.equals(((DefaultDependency)object).name);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static abstract class AbstractDependency<B extends ServiceBuilder<?>, V>
    implements Dependency<B, V>,
    Function<B, Supplier<V>> {
        private volatile Supplier<V> supplier = Functions.constantSupplier(null);

        @Override
        public V get() {
            return this.supplier.get();
        }

        @Override
        public void accept(B builder) {
            this.supplier = (Supplier)this.apply(builder);
        }
    }

    public static class SimpleDependency<B extends ServiceBuilder<?>, V>
    implements Dependency<B, V> {
        private final V value;

        protected SimpleDependency(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public void accept(B builder) {
        }
    }
}

