/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.Dependency;

public interface ServiceDependency<V>
extends Dependency<ServiceBuilder<?>, V> {
    public static <V> ServiceDependency<V> of(V value) {
        return value != null ? new SimpleServiceDependency<V>(value) : SimpleServiceDependency.NULL;
    }

    public static <V> ServiceDependency<V> on(ServiceName name) {
        return name != null ? new DefaultServiceDependency(name) : ServiceDependency.of(null);
    }

    public static class DefaultServiceDependency<V>
    extends Dependency.DefaultDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        DefaultServiceDependency(ServiceName name) {
            super(name);
        }
    }

    public static class SimpleServiceDependency<V>
    extends Dependency.SimpleDependency<ServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        static final ServiceDependency<Object> NULL = new SimpleServiceDependency<Object>(null);

        SimpleServiceDependency(V value) {
            super(value);
        }
    }
}

