/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.util.Objects;
import org.infinispan.persistence.jdbc.common.DatabaseType;

public class DbMetaData {
    private final DatabaseType type;
    private final int majorVersion;
    private final int minorVersion;
    private final int maxTableNameLength;
    private final boolean upsertDisabled;
    private final boolean indexingDisabled;
    private final boolean segmentedDisabled;

    public DbMetaData(DatabaseType type, Integer majorVersion, Integer minorVersion, int maxTableNameLength, boolean upsertDisabled, boolean indexingDisabled, boolean segmentedDisabled) {
        this.type = Objects.requireNonNull(type);
        this.majorVersion = majorVersion == null ? -1 : majorVersion;
        this.minorVersion = minorVersion == null ? -1 : minorVersion;
        this.maxTableNameLength = maxTableNameLength;
        this.upsertDisabled = upsertDisabled;
        this.indexingDisabled = indexingDisabled;
        this.segmentedDisabled = segmentedDisabled;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isUpsertDisabled() {
        return this.upsertDisabled;
    }

    public boolean isIndexingDisabled() {
        return this.indexingDisabled;
    }

    public boolean isSegmentedDisabled() {
        return this.segmentedDisabled;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }
}

