/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationTarget;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationCommandProcessor
extends ProtonAbstractReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Symbol[] OFFERED_LINK_CAPABILITIES = new Symbol[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK};
    private static final int PROCESSOR_RECEIVER_CREDITS = 10;
    private static final int PROCESSOR_RECEIVER_CREDITS_LOW = 3;
    private final ActiveMQServer server;
    private final AMQPFederationTarget federation;

    public AMQPFederationCommandProcessor(AMQPFederationTarget federation, AMQPSessionContext session, Receiver receiver) {
        super(session.getSessionSPI(), session.getAMQPConnectionContext(), session, receiver);
        this.server = this.protonSession.getServer();
        this.federation = federation;
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
        Target target = (Target)this.receiver.getRemoteTarget();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (target == null || !target.getDynamic()) {
            throw new ActiveMQAMQPInternalErrorException("Remote Target did not arrive as dynamic node: " + target);
        }
        target.setAddress(this.receiver.getName());
        this.receiver.setOfferedCapabilities(OFFERED_LINK_CAPABILITIES);
        this.flow();
    }

    @Override
    protected void actualDelivery(AMQPMessage message, Delivery delivery, Receiver receiver, Transaction tx) {
        logger.trace("{}::actualdelivery called for {}", (Object)this.server, (Object)message);
        delivery.setContext((Object)message);
        try {
            Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPFederationConstants.OPERATION_TYPE);
            if ("ADD_QUEUE_POLICY".equals(eventType)) {
                FederationReceiveFromQueuePolicy policy = AMQPFederationPolicySupport.decodeReceiveFromQueuePolicy(message, this.federation.getWildcardConfiguration());
                this.federation.addQueueMatchPolicy(policy);
            } else if ("ADD_ADDRESS_POLICY".equals(eventType)) {
                FederationReceiveFromAddressPolicy policy = AMQPFederationPolicySupport.decodeReceiveFromAddressPolicy(message, this.federation.getWildcardConfiguration());
                this.federation.addAddressMatchPolicy(policy);
            } else {
                this.federation.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Remote sent unknown command.")));
                return;
            }
            delivery.disposition((DeliveryState)Accepted.getInstance());
            delivery.settle();
            this.flow();
            this.connection.flush();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            this.federation.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Error while processing incoming control message: " + e.getMessage())));
        }
    }

    @Override
    protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
        return AMQPFederationCommandProcessor.createCreditRunnable(10, 3, this.receiver, connection, this);
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }
}

