/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorDirectValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.identity.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorTypeBridgeNode;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public abstract class AbstractPojoIndexingProcessorTypeNodeBuilder<T, U>
extends AbstractPojoProcessorNodeBuilder
implements PojoIndexMappingCollectorTypeNode {
    private final PojoIdentityMappingCollector identityMappingCollector;
    private final Collection<IndexObjectFieldReference> parentIndexObjectReferences;
    private final Collection<BoundTypeBridge<U>> boundBridges = new ArrayList<BoundTypeBridge<U>>();
    private final Map<String, PojoIndexingProcessorPropertyNodeBuilder<U, ?>> propertyNodeBuilders = new LinkedHashMap();

    public AbstractPojoIndexingProcessorTypeNodeBuilder(PojoMappingHelper mappingHelper, IndexBindingContext bindingContext, PojoIdentityMappingCollector identityMappingCollector, Collection<IndexObjectFieldReference> parentIndexObjectReferences) {
        super(mappingHelper, bindingContext);
        this.identityMappingCollector = identityMappingCollector;
        this.parentIndexObjectReferences = parentIndexObjectReferences;
    }

    @Override
    public void typeBinder(TypeBinder builder, Map<String, Object> params) {
        this.mappingHelper.indexModelBinder().bindType(this.bindingContext, this.getModelPath(), builder, params).ifPresent(this.boundBridges::add);
    }

    @Override
    public PojoIndexMappingCollectorPropertyNode property(String propertyName) {
        return this.propertyNodeBuilders.computeIfAbsent(propertyName, this::createPropertyNodeBuilder);
    }

    private PojoIndexingProcessorPropertyNodeBuilder<U, ?> createPropertyNodeBuilder(String propertyName) {
        return new PojoIndexingProcessorPropertyNodeBuilder(((BoundPojoModelPathTypeNode)this.getModelPath()).property(propertyName), this.mappingHelper, this.bindingContext, this.identityMappingCollector);
    }

    @Override
    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(TypeBridge::close, this.boundBridges, BoundTypeBridge::getBridge);
            closer.pushAll(BeanHolder::close, this.boundBridges, BoundTypeBridge::getBridgeHolder);
            closer.pushAll(PojoIndexingProcessorPropertyNodeBuilder::closeOnFailure, this.propertyNodeBuilders.values());
        }
    }

    public Optional<PojoIndexingProcessor<T>> build(AbstractPojoIndexingDependencyCollectorDirectValueNode<?, T> valueDependencyCollector) {
        return this.build(this.toType(valueDependencyCollector));
    }

    public Optional<PojoIndexingProcessor<T>> build(PojoIndexingDependencyCollectorTypeNode<U> dependencyCollector) {
        try {
            return this.doBuild(dependencyCollector);
        }
        catch (RuntimeException e) {
            this.failureCollector().add((Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    abstract BoundPojoModelPathTypeNode<U> getModelPath();

    protected PojoTypeAdditionalMetadata typeAdditionalMetadata() {
        return this.mappingHelper.typeAdditionalMetadataProvider().get(((BoundPojoModelPathTypeNode)this.getModelPath()).getTypeModel().rawType());
    }

    protected abstract PojoIndexingDependencyCollectorTypeNode<U> toType(AbstractPojoIndexingDependencyCollectorDirectValueNode<?, T> var1);

    protected abstract PojoIndexingProcessor<T> doBuild(Collection<IndexObjectFieldReference> var1, PojoIndexingProcessor<? super U> var2);

    private Optional<PojoIndexingProcessor<T>> doBuild(PojoIndexingDependencyCollectorTypeNode<U> dependencyCollector) {
        ArrayList<PojoIndexingProcessorTypeBridgeNode<U>> nestedNodes = new ArrayList<PojoIndexingProcessorTypeBridgeNode<U>>();
        try {
            for (BoundTypeBridge<U> boundBridge : this.boundBridges) {
                nestedNodes.add(new PojoIndexingProcessorTypeBridgeNode<U>(boundBridge.getBridgeHolder()));
                boundBridge.contributeDependencies(dependencyCollector);
            }
            this.propertyNodeBuilders.values().stream().map(builder -> builder.build(dependencyCollector)).filter(Optional::isPresent).map(Optional::get).forEach(nestedNodes::add);
            if (this.parentIndexObjectReferences.isEmpty() && nestedNodes.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(this.doBuild(this.parentIndexObjectReferences, this.createNested(nestedNodes)));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, nestedNodes);
            throw e;
        }
    }
}

