/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNestedPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchNestablePredicate
extends AbstractElasticsearchPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    AbstractElasticsearchNestablePredicate(AbstractElasticsearchPredicate.AbstractBuilder builder) {
        super(builder);
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        if (expectedParentNestedPath != null && !nestedPathHierarchy.contains(expectedParentNestedPath)) {
            throw log.invalidNestedObjectPathForPredicate(this, expectedParentNestedPath, this.getFieldPathsForErrorMessage());
        }
    }

    @Override
    public JsonObject toJsonQuery(PredicateRequestContext context) {
        int hierarchyLastIndex;
        String path;
        String expectedNestedPath;
        this.checkNestableWithin(context.getNestedPath());
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        String string = expectedNestedPath = nestedPathHierarchy.isEmpty() ? null : nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        if (Objects.equals(context.getNestedPath(), expectedNestedPath)) {
            return super.toJsonQuery(context);
        }
        PredicateRequestContext contextAfterImplicitNesting = context.withNestedPath(expectedNestedPath);
        JsonObject result = super.toJsonQuery(contextAfterImplicitNesting);
        for (int i = hierarchyLastIndex = nestedPathHierarchy.size() - 1; i >= 0 && !(path = nestedPathHierarchy.get(i)).equals(context.getNestedPath()); --i) {
            JsonObject outerObject = new JsonObject();
            JsonObject innerObject = new JsonObject();
            ElasticsearchNestedPredicate.wrap(this.indexNames(), path, outerObject, innerObject, result);
            result = outerObject;
        }
        return result;
    }

    protected abstract List<String> getNestedPathHierarchy();

    protected abstract List<String> getFieldPathsForErrorMessage();
}

