/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.wildfly.clustering.marshalling.protostream.FieldSetProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.FunctionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.FunctionalScalarMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ValueMarshaller;
import org.wildfly.clustering.marshalling.protostream.reflect.DecoratorMarshaller;
import org.wildfly.clustering.marshalling.protostream.reflect.SynchronizedDecoratorMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.CalendarMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.CollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetFieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.LinkedHashMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.MapEntryMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.MapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.OptionalMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SingletonMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.SortedSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UUIDBuilder;
import org.wildfly.clustering.marshalling.protostream.util.UUIDMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UnmodifiableCollectionMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.UnmodifiableMapMarshaller;
import org.wildfly.common.function.Functions;

public enum UtilMarshallerProvider implements ProtoStreamMarshallerProvider
{
    ARRAY_DEQUE(new CollectionMarshaller<ArrayDeque>(ArrayDeque::new)),
    ARRAY_LIST(new CollectionMarshaller<ArrayList>(ArrayList::new)),
    BIT_SET(new FunctionalScalarMarshaller<BitSet, byte[]>(Scalar.BYTE_ARRAY.cast(byte[].class), BitSet::new, BitSet::isEmpty, BitSet::toByteArray, BitSet::valueOf)),
    CALENDAR(new CalendarMarshaller()),
    CURRENCY(new FunctionalScalarMarshaller<Currency, String>(Currency.class, Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)UtilMarshallerProvider.getDefaultCurrency()), Currency::getCurrencyCode, Currency::getInstance)),
    DATE(new FunctionalMarshaller<Date, Instant>(Date.class, Instant.class, Date::toInstant, Date::from)),
    EMPTY_LIST(new ValueMarshaller<List<T>>(Collections.emptyList())),
    EMPTY_MAP(new ValueMarshaller<Map<K, V>>(Collections.emptyMap())),
    EMPTY_NAVIGABLE_MAP(new ValueMarshaller<NavigableMap<K, V>>(Collections.emptyNavigableMap())),
    EMPTY_NAVIGABLE_SET(new ValueMarshaller<NavigableSet<E>>(Collections.emptyNavigableSet())),
    EMPTY_SET(new ValueMarshaller<Set<T>>(Collections.emptySet())),
    EMPTY_SORTED_MAP(new ValueMarshaller<SortedMap<K, V>>(Collections.emptySortedMap())),
    EMPTY_SORTED_SET(new ValueMarshaller<SortedSet<E>>(Collections.emptySortedSet())),
    ENUM_MAP(new EnumMapMarshaller<E>()),
    ENUM_SET(new FieldSetProtoStreamMarshaller<EnumSet, V>(EnumSet.class, new EnumSetFieldSetMarshaller<E>())),
    HASH_MAP(new MapMarshaller<HashMap>(HashMap::new)),
    HASH_SET(new CollectionMarshaller<HashSet>(HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapMarshaller()),
    LINKED_HASH_SET(new CollectionMarshaller<LinkedHashSet>(LinkedHashSet::new)),
    LINKED_LIST(new CollectionMarshaller<LinkedList>(LinkedList::new)),
    LIST12(new UnmodifiableCollectionMarshaller<E, List>(List.of(Boolean.TRUE).getClass().asSubclass(List.class), List::of)),
    LISTN(new UnmodifiableCollectionMarshaller<E, List>(List.of().getClass().asSubclass(List.class), List::of)),
    LOCALE(new FunctionalScalarMarshaller<T, String>(Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)Locale.getDefault()), Locale::toLanguageTag, Locale::forLanguageTag)),
    MAP1(new UnmodifiableMapMarshaller<Map>(Map.of(Boolean.TRUE, Boolean.FALSE).getClass().asSubclass(Map.class), Map::ofEntries)),
    MAPN(new UnmodifiableMapMarshaller<Map>(Map.of().getClass().asSubclass(Map.class), Map::ofEntries)),
    OPTIONAL(OptionalMarshaller.OBJECT),
    OPTIONAL_DOUBLE(OptionalMarshaller.DOUBLE),
    OPTIONAL_INT(OptionalMarshaller.INT),
    OPTIONAL_LONG(OptionalMarshaller.LONG),
    SET12(new UnmodifiableCollectionMarshaller<E, Set>(Set.of(Boolean.TRUE).getClass().asSubclass(Set.class), Set::of)),
    SETN(new UnmodifiableCollectionMarshaller<E, Set>(Set.of().getClass().asSubclass(Set.class), Set::of)),
    SIMPLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryMarshaller<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionMarshaller<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapMarshaller(Collections::singletonMap)),
    SINGLETON_SET(new SingletonCollectionMarshaller<Set>(Collections::singleton)),
    SYNCHRONIZED_COLLECTION(new SynchronizedDecoratorMarshaller<List<T>>(Collection.class, Collections::synchronizedCollection, Collections.emptyList())),
    SYNCHRONIZED_LIST(new SynchronizedDecoratorMarshaller<LinkedList<E>>(List.class, Collections::synchronizedList, new LinkedList<E>())),
    SYNCHRONIZED_MAP(new SynchronizedDecoratorMarshaller<Map<K, V>>(Map.class, Collections::synchronizedMap, Collections.emptyMap())),
    SYNCHRONIZED_NAVIGABLE_MAP(new SynchronizedDecoratorMarshaller<NavigableMap<K, V>>(NavigableMap.class, Collections::synchronizedNavigableMap, Collections.emptyNavigableMap())),
    SYNCHRONIZED_NAVIGABLE_SET(new SynchronizedDecoratorMarshaller<NavigableSet<E>>(NavigableSet.class, Collections::synchronizedNavigableSet, Collections.emptyNavigableSet())),
    SYNCHRONIZED_RANDOM_ACCESS_LIST(new SynchronizedDecoratorMarshaller<List<T>>(List.class, Collections::synchronizedList, Collections.emptyList())),
    SYNCHRONIZED_SET(new SynchronizedDecoratorMarshaller<Set<T>>(Set.class, Collections::synchronizedSet, Collections.emptySet())),
    SYNCHRONIZED_SORTED_MAP(new SynchronizedDecoratorMarshaller<SortedMap<K, V>>(SortedMap.class, Collections::synchronizedSortedMap, Collections.emptySortedMap())),
    SYNCHRONIZED_SORTED_SET(new SynchronizedDecoratorMarshaller<SortedSet<E>>(SortedSet.class, Collections::synchronizedSortedSet, Collections.emptySortedSet())),
    TIME_ZONE(new FunctionalScalarMarshaller<TimeZone, String>(TimeZone.class, Scalar.STRING.cast(String.class), Functions.constantSupplier((Object)TimeZone.getDefault()), TimeZone::getID, TimeZone::getTimeZone)),
    TREE_MAP(new SortedMapMarshaller<TreeMap>(TreeMap::new)),
    TREE_SET(new SortedSetMarshaller<TreeSet>(TreeSet::new)),
    UNMODIFIABLE_COLLECTION(new DecoratorMarshaller<List<T>>(Collection.class, Collections::unmodifiableCollection, Collections.emptyList())),
    UNMODIFIABLE_LIST(new DecoratorMarshaller<LinkedList<E>>(List.class, Collections::unmodifiableList, new LinkedList<E>())),
    UNMODIFIABLE_MAP(new DecoratorMarshaller<Map<K, V>>(Map.class, Collections::unmodifiableMap, Collections.emptyMap())),
    UNMODIFIABLE_NAVIGABLE_MAP(new DecoratorMarshaller<NavigableMap<K, V>>(NavigableMap.class, Collections::unmodifiableNavigableMap, Collections.emptyNavigableMap())),
    UNMODIFIABLE_NAVIGABLE_SET(new DecoratorMarshaller<NavigableSet<E>>(NavigableSet.class, Collections::unmodifiableNavigableSet, Collections.emptyNavigableSet())),
    UNMODIFIABLE_RANDOM_ACCESS_LIST(new DecoratorMarshaller<List<T>>(List.class, Collections::unmodifiableList, Collections.emptyList())),
    UNMODIFIABLE_SET(new DecoratorMarshaller<Set<T>>(Set.class, Collections::unmodifiableSet, Collections.emptySet())),
    UNMODIFIABLE_SORTED_MAP(new DecoratorMarshaller<SortedMap<K, V>>(SortedMap.class, Collections::unmodifiableSortedMap, Collections.emptySortedMap())),
    UNMODIFIABLE_SORTED_SET(new DecoratorMarshaller<SortedSet<E>>(SortedSet.class, Collections::unmodifiableSortedSet, Collections.emptySortedSet())),
    UUID(new FieldSetProtoStreamMarshaller<UUID, UUIDBuilder>(UUIDMarshaller.INSTANCE));

    private final ProtoStreamMarshaller<?> marshaller;

    private UtilMarshallerProvider(ProtoStreamMarshaller<?> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this.marshaller;
    }

    private static Currency getDefaultCurrency() {
        try {
            return Currency.getInstance(Locale.getDefault());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

