/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import org.omg.CORBA.Any;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.AbstractAnalysis;
import org.wildfly.iiop.openjdk.rmi.Util;

public class ConstantAnalysis
extends AbstractAnalysis {
    private Class type;
    private Object value;

    ConstantAnalysis(String javaName, Class type, Object value) {
        super(javaName);
        if (type == Void.TYPE || !type.isPrimitive() && type != String.class) {
            throw IIOPLogger.ROOT_LOGGER.badConstantType(type.getName());
        }
        this.type = type;
        this.value = value;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void insertValue(Any any) {
        if (this.type == String.class) {
            any.insert_wstring((String)this.value);
        } else {
            Util.insertAnyPrimitive(any, this.value);
        }
    }
}

