/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractXmlMarshallingHandler
implements OperationStepHandler {
    private static final Set<Action.ActionEffect> EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));
    private final ConfigurationPersister configPersister;

    protected AbstractXmlMarshallingHandler(ConfigurationPersister configPersister) {
        this.configPersister = configPersister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) {
        PathAddress pa = context.getCurrentAddress();
        AuthorizationResult authResult = context.authorize(operation, EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), pa, authResult.getExplanation());
        }
        Resource resource = context.readResourceFromRoot(this.getBaseAddress());
        ModelNode model = Resource.Tools.readModel(resource);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             BufferedOutputStream output = new BufferedOutputStream(baos);){
            this.configPersister.marshallAsXml(model, output);
            this.attachResult(context, baos);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException | ConfigurationPersistenceException e) {
            ControllerLogger.MGMT_OP_LOGGER.failedExecutingOperation(e, operation.require("operation"), pa);
            context.getFailureDescription().set(e.toString());
        }
    }

    protected abstract void attachResult(OperationContext var1, ByteArrayOutputStream var2);

    protected PathAddress getBaseAddress() {
        return PathAddress.EMPTY_ADDRESS;
    }
}

