/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.AsyncServiceBuilder;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;

public interface ServiceInstaller
extends ResourceServiceInstaller,
DeploymentServiceInstaller,
Installer<RequirementServiceTarget> {
    public static <V> UnaryBuilder<V, V> builder(V value) {
        return (UnaryBuilder)ServiceInstaller.builder(Functions.constantSupplier(value)).asActive();
    }

    public static <V> UnaryBuilder<V, V> builder(ServiceDependency<V> dependency) {
        ServiceDependency<V> supplier = dependency;
        return (UnaryBuilder)((UnaryBuilder)ServiceInstaller.builder(supplier).requires((Consumer)((Object)dependency))).asPassive();
    }

    public static <V> UnaryBuilder<V, V> builder(Supplier<V> factory) {
        return ServiceInstaller.builder(Function.identity(), factory);
    }

    public static <T, V> UnaryBuilder<T, V> builder(Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultUnaryBuilder<T, V>(mapper, factory);
    }

    public static Builder builder(final org.wildfly.service.ServiceInstaller installer) {
        return (Builder)new DefaultNullaryBuilder(new Service(){

            public void start(StartContext context) {
                installer.install(context.getChildTarget());
            }

            public void stop(StopContext context) {
            }
        }).asActive();
    }

    public static Builder builder(final Runnable startTask, final Runnable stopTask) {
        return new DefaultNullaryBuilder(new Service(){

            public void start(StartContext context) throws StartException {
                startTask.run();
            }

            public void stop(StopContext context) {
                stopTask.run();
            }
        });
    }

    @Override
    default public Consumer<OperationContext> install(OperationContext context) {
        final ServiceController controller = this.install((ServiceTarget)context.getCapabilityServiceTarget());
        return new Consumer<OperationContext>(){

            @Override
            public void accept(OperationContext context) {
                context.removeService(controller);
            }
        };
    }

    @Override
    default public void install(DeploymentPhaseContext context) {
        this.install((ServiceTarget)context.getRequirementServiceTarget());
    }

    public static class DefaultUnaryBuilder<T, V>
    extends Installer.AbstractUnaryBuilder<UnaryBuilder<T, V>, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
    implements UnaryBuilder<T, V> {
        private volatile boolean sync = true;

        DefaultUnaryBuilder(Function<T, V> mapper, Supplier<T> factory) {
            super(mapper, factory);
        }

        public UnaryBuilder<T, V> async() {
            this.sync = false;
            return this;
        }

        public ServiceInstaller build() {
            final boolean sync = this.sync;
            final AsyncServiceBuilder.Async async = this.hasStopTask() ? AsyncServiceBuilder.Async.START_AND_STOP : AsyncServiceBuilder.Async.START_ONLY;
            return new DefaultServiceInstaller((Installer.Configuration<RequirementServiceBuilder<?>, RequirementServiceBuilder<?>>)this, new Function<RequirementServiceTarget, RequirementServiceBuilder<?>>(){

                @Override
                public RequirementServiceBuilder<?> apply(RequirementServiceTarget target) {
                    AsyncServiceBuilder builder = target.addService();
                    return !sync ? new AsyncServiceBuilder(builder, async) : builder;
                }
            });
        }

        protected UnaryBuilder<T, V> builder() {
            return this;
        }
    }

    public static class DefaultNullaryBuilder
    extends Installer.AbstractNullaryBuilder<Builder, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>, RequirementServiceBuilder<?>>
    implements Builder {
        private volatile boolean sync = true;

        DefaultNullaryBuilder(Service service) {
            super(service);
        }

        public Builder async() {
            this.sync = false;
            return this;
        }

        public ServiceInstaller build() {
            final boolean sync = this.sync;
            return new DefaultServiceInstaller((Installer.Configuration<RequirementServiceBuilder<?>, RequirementServiceBuilder<?>>)this, new Function<RequirementServiceTarget, RequirementServiceBuilder<?>>(){

                @Override
                public RequirementServiceBuilder<?> apply(RequirementServiceTarget target) {
                    AsyncServiceBuilder builder = target.addService();
                    return !sync ? new AsyncServiceBuilder(builder, AsyncServiceBuilder.Async.START_AND_STOP) : builder;
                }
            });
        }

        protected Builder builder() {
            return this;
        }
    }

    public static class DefaultServiceInstaller
    extends Installer.DefaultInstaller<RequirementServiceTarget, RequirementServiceBuilder<?>, RequirementServiceBuilder<?>>
    implements ServiceInstaller {
        DefaultServiceInstaller(Installer.Configuration<RequirementServiceBuilder<?>, RequirementServiceBuilder<?>> config, Function<RequirementServiceTarget, RequirementServiceBuilder<?>> serviceBuilderFactory) {
            super(config, serviceBuilderFactory);
        }
    }

    public static interface UnaryBuilder<T, V>
    extends Installer.AsyncBuilder<UnaryBuilder<T, V>>,
    Installer.UnaryBuilder<UnaryBuilder<T, V>, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>, T, V> {
    }

    public static interface Builder
    extends Installer.AsyncBuilder<Builder>,
    Installer.Builder<Builder, ServiceInstaller, RequirementServiceTarget, RequirementServiceBuilder<?>> {
    }
}

