/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.jca.core.workmanager.ClassDefinition;

public class ClassBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ClassDefinition> definitions;

    public static ClassBundle fromListOfMaps(List<Map<String, Object>> mapList) {
        ArrayList<ClassDefinition> listOfDefinitions = new ArrayList<ClassDefinition>(mapList.size());
        for (Map<String, Object> classDefinitionMap : mapList) {
            listOfDefinitions.add(ClassDefinition.fromMap(classDefinitionMap));
        }
        return new ClassBundle(listOfDefinitions);
    }

    public List<Map<String, Object>> toListOfMaps() {
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(this.getDefinitions().size());
        for (ClassDefinition classDefinition : this.getDefinitions()) {
            returnList.add(classDefinition.toMap());
        }
        return returnList;
    }

    public ClassBundle() {
        this(new ArrayList<ClassDefinition>(1));
    }

    public ClassBundle(List<ClassDefinition> definitions) {
        this.definitions = definitions;
    }

    public List<ClassDefinition> getDefinitions() {
        return this.definitions;
    }

    public int hashCode() {
        int result = 17;
        return result += this.definitions != null ? 7 * this.definitions.hashCode() : 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClassBundle)) {
            return false;
        }
        ClassBundle cb = (ClassBundle)other;
        return !(this.definitions == null ? cb.definitions != null : !this.definitions.equals(cb.definitions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassBundle@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[definitions=").append(this.definitions);
        sb.append("]");
        return sb.toString();
    }
}

