/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import java.util.Vector;
import org.hornetq.core.version.Version;

public class HornetQConnectionMetaData
implements ConnectionMetaData {
    private static final String HORNETQ = "HornetQ";
    private final Version serverVersion;

    public HornetQConnectionMetaData(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getJMSVersion() throws JMSException {
        return "2.0";
    }

    public int getJMSMajorVersion() throws JMSException {
        return 2;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 0;
    }

    public String getJMSProviderName() throws JMSException {
        return HORNETQ;
    }

    public String getProviderVersion() throws JMSException {
        return this.serverVersion.getFullVersion();
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.serverVersion.getMajorVersion();
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.serverVersion.getMinorVersion();
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }
}

