/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.ra.recovery.RecoveryManager;
import org.jgroups.JChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 4756893709825838770L;
    public static final String PRODUCT_NAME = "ActiveMQ Artemis";
    private BootstrapContext ctx;
    private final ActiveMQRAProperties raProperties;
    private String unparsedProperties;
    private String unparsedConnectors;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, ActiveMQActivation> activations;
    private ActiveMQConnectionFactory defaultActiveMQConnectionFactory;
    private ActiveMQConnectionFactory recoveryActiveMQConnectionFactory;
    private TransactionSynchronizationRegistry tsr;
    private String unparsedJndiParams;
    private final RecoveryManager recoveryManager;
    private boolean useAutoRecovery = true;
    private final List<ActiveMQRAManagedConnectionFactory> managedConnectionFactories = new ArrayList<ActiveMQRAManagedConnectionFactory>();
    private String entries;
    private boolean ignoreJTA;
    private final Map<ConnectionFactoryProperties, Pair<ActiveMQConnectionFactory, AtomicInteger>> knownConnectionFactories = new HashMap<ConnectionFactoryProperties, Pair<ActiveMQConnectionFactory, AtomicInteger>>();

    public ActiveMQResourceAdapter() {
        logger.trace("constructor()");
        this.raProperties = new ActiveMQRAProperties();
        this.configured = new AtomicBoolean(false);
        this.activations = Collections.synchronizedMap(new IdentityHashMap());
        this.recoveryManager = new RecoveryManager();
    }

    public TransactionSynchronizationRegistry getTSR() {
        return this.tsr;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (spec == null) {
            throw ActiveMQRABundle.BUNDLE.noActivationSpec();
        }
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        logger.trace("endpointActivation({}, {})", (Object)endpointFactory, (Object)spec);
        ActiveMQActivation activation = new ActiveMQActivation(this, endpointFactory, (ActiveMQActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        logger.trace("endpointDeactivation({}, {})", (Object)endpointFactory, (Object)spec);
        ActiveMQActivation activation = this.activations.remove(spec);
        if (activation != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (logger.isTraceEnabled()) {
            logger.trace("getXAResources({})", (Object)Arrays.toString(specs));
        }
        if (this.useAutoRecovery) {
            return null;
        }
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        for (ActivationSpec spec : specs) {
            ActiveMQActivation activation = this.activations.get(spec);
            if (activation == null) continue;
            xaresources.addAll(activation.getXAResources());
        }
        return xaresources.toArray(new XAResource[xaresources.size()]);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        logger.trace("start({})", (Object)ctx);
        this.tsr = ctx.getTransactionSynchronizationRegistry();
        this.recoveryManager.start(this.useAutoRecovery);
        this.ctx = ctx;
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceAdapterInternalException("Unable to create activation", (Throwable)e);
            }
        }
        ActiveMQRALogger.LOGGER.resourceAdaptorStarted();
    }

    public void stop() {
        logger.trace("stop()");
        for (Map.Entry<ActivationSpec, ActiveMQActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                logger.debug("Ignored", (Throwable)ignored);
            }
        }
        this.activations.clear();
        for (ActiveMQRAManagedConnectionFactory activeMQRAManagedConnectionFactory : this.managedConnectionFactories) {
            activeMQRAManagedConnectionFactory.stop();
        }
        this.managedConnectionFactories.clear();
        for (Pair pair : this.knownConnectionFactories.values()) {
            ((ActiveMQConnectionFactory)pair.getA()).close();
        }
        this.knownConnectionFactories.clear();
        if (this.defaultActiveMQConnectionFactory != null) {
            this.defaultActiveMQConnectionFactory.close();
        }
        if (this.recoveryActiveMQConnectionFactory != null) {
            this.recoveryActiveMQConnectionFactory.close();
        }
        this.recoveryManager.stop();
        ActiveMQRALogger.LOGGER.raStopped();
    }

    public void setUseAutoRecovery(Boolean useAutoRecovery) {
        this.useAutoRecovery = useAutoRecovery;
    }

    public Boolean isUseAutoRecovery() {
        return this.useAutoRecovery;
    }

    public Boolean isUseMaskedPassword() {
        return this.raProperties.isUseMaskedPassword();
    }

    public void setUseMaskedPassword(Boolean useMaskedPassword) {
        this.raProperties.setUseMaskedPassword(useMaskedPassword);
    }

    public void setPasswordCodec(String passwordCodec) {
        this.raProperties.setPasswordCodec(passwordCodec);
    }

    public String getPasswordCodec() {
        return this.raProperties.getPasswordCodec();
    }

    public void setConnectorClassName(String connectorClassName) {
        logger.trace("setTransportType({})", (Object)connectorClassName);
        this.unparsedConnectors = connectorClassName;
        this.raProperties.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectorClassName() {
        return this.unparsedConnectors;
    }

    public String getConnectionParameters() {
        return this.unparsedProperties;
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.unparsedProperties = config;
            this.raProperties.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(config));
        }
    }

    public Boolean getHA() {
        return this.raProperties.isHA();
    }

    public void setHA(Boolean ha) {
        this.raProperties.setHA(ha);
    }

    public String getEntries() {
        return this.entries;
    }

    public String getJndiName() {
        Matcher m;
        if (this.entries != null && !this.entries.isEmpty() && (m = Pattern.compile("\"(.*?)\"").matcher(this.entries)).find()) {
            return m.group(1);
        }
        return null;
    }

    public void setEntries(String entries) {
        this.entries = entries;
    }

    public String getDiscoveryAddress() {
        logger.trace("getDiscoveryGroupAddress()");
        return this.raProperties.getDiscoveryAddress();
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.raProperties.setJgroupsFile(jgroupsFile);
    }

    public String getJgroupsFile() {
        return this.raProperties.getJgroupsFile();
    }

    public String getJgroupsChannelName() {
        return this.raProperties.getJgroupsChannelName();
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.raProperties.setJgroupsChannelName(jgroupsChannelName);
    }

    public void setDiscoveryAddress(String dgn) {
        logger.trace("setDiscoveryGroupAddress({})", (Object)dgn);
        this.raProperties.setDiscoveryAddress(dgn);
    }

    public Integer getDiscoveryPort() {
        logger.trace("getDiscoveryGroupPort()");
        return this.raProperties.getDiscoveryPort();
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        logger.trace("setDiscoveryLocalBindAddress({})", (Object)discoveryLocalBindAddress);
        this.raProperties.setDiscoveryLocalBindAddress(discoveryLocalBindAddress);
    }

    public String getDiscoveryLocalBindAddress() {
        logger.trace("getDiscoveryLocalBindAddress()");
        return this.raProperties.getDiscoveryLocalBindAddress();
    }

    public void setDiscoveryPort(Integer dgp) {
        logger.trace("setDiscoveryGroupPort({})", (Object)dgp);
        this.raProperties.setDiscoveryPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        logger.trace("getDiscoveryRefreshTimeout()");
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        logger.trace("setDiscoveryRefreshTimeout({})", (Object)discoveryRefreshTimeout);
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        logger.trace("getDiscoveryInitialWaitTimeout()");
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        logger.trace("setDiscoveryInitialWaitTimeout({})", (Object)discoveryInitialWaitTimeout);
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public Long getClientFailureCheckPeriod() {
        logger.trace("getClientFailureCheckPeriod()");
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        logger.trace("setClientFailureCheckPeriod({})", (Object)clientFailureCheckPeriod);
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        logger.trace("getConnectionTTL()");
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        logger.trace("setConnectionTTL({})", (Object)connectionTTL);
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Boolean isCacheLargeMessagesClient() {
        logger.trace("isCacheLargeMessagesClient()");
        return this.raProperties.isCacheLargeMessagesClient();
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        logger.trace("setCacheLargeMessagesClient({})", (Object)cacheLargeMessagesClient);
        this.raProperties.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public Boolean isCompressLargeMessage() {
        logger.trace("isCompressLargeMessage()");
        return this.raProperties.isCompressLargeMessage();
    }

    @Deprecated
    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
    }

    @Deprecated
    public Boolean isFailoverOnInitialConnection() {
        return false;
    }

    public void setCacheDestinations(Boolean cacheDestinations) {
        logger.trace("setCacheDestinations({})", (Object)cacheDestinations);
        this.raProperties.setCacheDestinations(cacheDestinations);
    }

    public Boolean isCacheDestinations() {
        logger.trace("isCacheDestinations()");
        return this.raProperties.isCacheDestinations();
    }

    public void setEnable1xPrefixes(Boolean enable1xPrefixes) {
        logger.trace("setEnable1xPrefixes({})", (Object)enable1xPrefixes);
        this.raProperties.setEnable1xPrefixes(enable1xPrefixes);
    }

    public Boolean isEnable1xPrefixes() {
        logger.trace("isEnable1xPrefixes()");
        return this.raProperties.isEnable1xPrefixes();
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        logger.trace("setCompressLargeMessage({})", (Object)compressLargeMessage);
        this.raProperties.setCompressLargeMessage(compressLargeMessage);
    }

    public Integer getCompressionLevel() {
        logger.trace("getCompressionLevel()");
        return this.raProperties.getCompressionLevel();
    }

    public void setCompressionLevel(Integer compressionLevel) {
        logger.trace("setCompressionLevel({})", (Object)compressionLevel);
        this.raProperties.setCompressionLevel(compressionLevel);
    }

    public Long getCallTimeout() {
        logger.trace("getCallTimeout()");
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        logger.trace("setCallTimeout({})", (Object)callTimeout);
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Long getCallFailoverTimeout() {
        logger.trace("getCallFailoverTimeout()");
        return this.raProperties.getCallFailoverTimeout();
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        logger.trace("setCallFailoverTimeout({})", (Object)callFailoverTimeout);
        this.raProperties.setCallFailoverTimeout(callFailoverTimeout);
    }

    public Integer getDupsOKBatchSize() {
        logger.trace("getDupsOKBatchSize()");
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        logger.trace("setDupsOKBatchSize({})", (Object)dupsOKBatchSize);
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        logger.trace("getTransactionBatchSize()");
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        logger.trace("setTransactionBatchSize({})", (Object)transactionBatchSize);
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        logger.trace("getConsumerWindowSize()");
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        logger.trace("setConsumerWindowSize({})", (Object)consumerWindowSize);
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        logger.trace("getConsumerMaxRate()");
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        logger.trace("setConsumerMaxRate({})", (Object)consumerMaxRate);
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        logger.trace("getConfirmationWindowSize()");
        return this.raProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        logger.trace("setConfirmationWindowSize({})", (Object)confirmationWindowSize);
        this.raProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        logger.trace("getProducerMaxRate()");
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        logger.trace("setProducerMaxRate({})", (Object)producerMaxRate);
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public void setUseTopologyForLoadBalancing(Boolean useTopologyForLoadBalancing) {
        this.raProperties.setUseTopologyForLoadBalancing(useTopologyForLoadBalancing);
    }

    public Boolean getUseTopologyForLoadBalancing() {
        return this.raProperties.isUseTopologyForLoadBalancing();
    }

    public Boolean isUseTopologyForLoadBalancing() {
        return this.raProperties.isUseTopologyForLoadBalancing();
    }

    public Integer getProducerWindowSize() {
        logger.trace("getProducerWindowSize()");
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        logger.trace("setProducerWindowSize({})", (Object)producerWindowSize);
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public String getProtocolManagerFactoryStr() {
        logger.trace("getProtocolManagerFactoryStr()");
        return this.raProperties.getProtocolManagerFactoryStr();
    }

    public void setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        logger.trace("setProtocolManagerFactoryStr({})", (Object)protocolManagerFactoryStr);
        this.raProperties.setProtocolManagerFactoryStr(protocolManagerFactoryStr);
    }

    public String getDeserializationBlackList() {
        logger.trace("getDeserializationBlackList()");
        return this.raProperties.getDeserializationBlackList();
    }

    public void setDeserializationBlackList(String deserializationBlackList) {
        logger.trace("setDeserializationBlackList({})", (Object)deserializationBlackList);
        this.raProperties.setDeserializationBlackList(deserializationBlackList);
    }

    public String getDeserializationWhiteList() {
        logger.trace("getDeserializationWhiteList()");
        return this.raProperties.getDeserializationWhiteList();
    }

    public void setDeserializationWhiteList(String deserializationWhiteList) {
        logger.trace("setDeserializationWhiteList({})", (Object)deserializationWhiteList);
        this.raProperties.setDeserializationWhiteList(deserializationWhiteList);
    }

    public Integer getMinLargeMessageSize() {
        logger.trace("getMinLargeMessageSize()");
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        logger.trace("setMinLargeMessageSize({})", (Object)minLargeMessageSize);
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        logger.trace("getBlockOnAcknowledge()");
        return this.raProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        logger.trace("setBlockOnAcknowledge({})", (Object)blockOnAcknowledge);
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonDurableSend() {
        logger.trace("getBlockOnNonDurableSend()");
        return this.raProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        logger.trace("setBlockOnNonDurableSend({})", (Object)blockOnNonDurableSend);
        this.raProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean getBlockOnDurableSend() {
        logger.trace("getBlockOnDurableSend()");
        return this.raProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        logger.trace("setBlockOnDurableSend({})", (Object)blockOnDurableSend);
        this.raProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean getAutoGroup() {
        logger.trace("getAutoGroup()");
        return this.raProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        logger.trace("setAutoGroup({})", (Object)autoGroup);
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Boolean getPreAcknowledge() {
        logger.trace("getPreAcknowledge()");
        return this.raProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        logger.trace("setPreAcknowledge({})", (Object)preAcknowledge);
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Integer getInitialConnectAttempts() {
        logger.trace("getInitialConnectAttempts()");
        return this.raProperties.getInitialConnectAttempts();
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        logger.trace("setInitialConnectionAttempts({})", (Object)initialConnectAttempts);
        this.raProperties.setInitialConnectAttempts(initialConnectAttempts);
    }

    public Integer getInitialMessagePacketSize() {
        logger.trace("getInitialMessagePacketSize()");
        return this.raProperties.getInitialMessagePacketSize();
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        logger.trace("setInitialMessagePacketSize({})", (Object)initialMessagePacketSize);
        this.raProperties.setInitialMessagePacketSize(initialMessagePacketSize);
    }

    public Long getRetryInterval() {
        logger.trace("getRetryInterval()");
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        logger.trace("setRetryInterval({})", (Object)retryInterval);
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        logger.trace("getRetryIntervalMultiplier()");
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        logger.trace("setRetryIntervalMultiplier({})", (Object)retryIntervalMultiplier);
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Long getMaxRetryInterval() {
        logger.trace("getMaxRetryInterval()");
        return this.raProperties.getMaxRetryInterval();
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        logger.trace("setMaxRetryInterval({})", (Object)maxRetryInterval);
        this.raProperties.setMaxRetryInterval(maxRetryInterval);
    }

    public Integer getReconnectAttempts() {
        logger.trace("getReconnectAttempts()");
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        logger.trace("setReconnectAttempts({})", (Object)reconnectAttempts);
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        logger.trace("setFailoverOnServerShutdown({})", (Object)connectionLoadBalancingPolicyClassName);
        this.raProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.raProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        logger.trace("setFailoverOnServerShutdown({})", (Object)scheduledThreadPoolMaxSize);
        this.raProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.raProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        logger.trace("setFailoverOnServerShutdown({})", (Object)threadPoolMaxSize);
        this.raProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getUseGlobalPools() {
        return this.raProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        logger.trace("setFailoverOnServerShutdown({})", (Object)useGlobalPools);
        this.raProperties.setUseGlobalPools(useGlobalPools);
    }

    public String getUserName() {
        logger.trace("getUserName()");
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        logger.trace("setUserName({})", (Object)userName);
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        logger.trace("getPassword()");
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public boolean isUseJNDI() {
        return this.raProperties.isUseJNDI();
    }

    public void setUseJNDI(Boolean value) {
        this.raProperties.setUseJNDI(value);
    }

    public String getJndiParams() {
        return this.unparsedJndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.unparsedJndiParams = jndiParams;
        this.raProperties.setParsedJndiParams(ActiveMQRaUtils.parseHashtableConfig(jndiParams));
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.raProperties.getParsedJndiParams();
    }

    public String getClientID() {
        logger.trace("getClientID()");
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        logger.trace("setClientID({})", (Object)clientID);
        this.raProperties.setClientID(clientID);
    }

    public String getGroupID() {
        logger.trace("getGroupID()");
        return this.raProperties.getGroupID();
    }

    public void setGroupID(String groupID) {
        logger.trace("setGroupID({})", (Object)groupID);
        this.raProperties.setGroupID(groupID);
    }

    public Boolean getUseLocalTx() {
        logger.trace("getUseLocalTx()");
        return this.raProperties.getUseLocalTx();
    }

    public void setUseLocalTx(Boolean localTx) {
        logger.trace("setUseXA({})", (Object)localTx);
        this.raProperties.setUseLocalTx(localTx);
    }

    public int getSetupAttempts() {
        logger.trace("getSetupAttempts()");
        return this.raProperties.getSetupAttempts();
    }

    public void setSetupAttempts(Integer setupAttempts) {
        logger.trace("setSetupAttempts({})", (Object)setupAttempts);
        this.raProperties.setSetupAttempts(setupAttempts);
    }

    public long getSetupInterval() {
        logger.trace("getSetupInterval()");
        return this.raProperties.getSetupInterval();
    }

    public void setSetupInterval(Long interval) {
        logger.trace("setSetupInterval({})", (Object)interval);
        this.raProperties.setSetupInterval(interval);
    }

    public boolean equals(Object obj) {
        logger.trace("equals({})", obj);
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQResourceAdapter) {
            return this.raProperties.equals(((ActiveMQResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        logger.trace("hashCode()");
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        logger.trace("getWorkManager()");
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted, boolean useLocalTx, Integer txTimeout) throws Exception {
        ClientSession result;
        if (deliveryTransacted || useLocalTx) {
            result = useLocalTx ? parameterFactory.createSession(user, pass, false, false, false, false, 0) : parameterFactory.createSession(user, pass, true, false, false, false, 0);
        } else if (preAck != null && preAck.booleanValue()) {
            result = parameterFactory.createSession(user, pass, false, true, true, true, -1);
        } else {
            switch (ackMode) {
                case 1: {
                    result = parameterFactory.createSession(user, pass, false, true, true, false, 0);
                    break;
                }
                case 3: {
                    int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
                    result = parameterFactory.createSession(user, pass, false, true, true, false, actDupsOkBatchSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
                }
            }
        }
        logger.debug("Using queue connection {}", (Object)result);
        return result;
    }

    public RecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    public ActiveMQRAProperties getProperties() {
        logger.trace("getProperties()");
        return this.raProperties;
    }

    protected void setup() throws ActiveMQException {
        this.raProperties.init();
        this.defaultActiveMQConnectionFactory = this.newConnectionFactory(this.raProperties);
        this.recoveryActiveMQConnectionFactory = this.createRecoveryActiveMQConnectionFactory(this.raProperties);
        HashMap<String, String> recoveryConfProps = new HashMap<String, String>();
        recoveryConfProps.put("JNDI_NAME", this.getJndiName());
        this.recoveryManager.register(this.recoveryActiveMQConnectionFactory, this.raProperties.getUserName(), this.raProperties.getPassword(), recoveryConfProps);
    }

    public Map<ActivationSpec, ActiveMQActivation> getActivations() {
        return this.activations;
    }

    public ActiveMQConnectionFactory getDefaultActiveMQConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.defaultActiveMQConnectionFactory;
    }

    public String getJgroupsChannelLocatorClass() {
        return this.raProperties.getJgroupsChannelLocatorClass();
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.raProperties.setJgroupsChannelLocatorClass(jgroupsChannelLocatorClass);
    }

    public String getJgroupsChannelRefName() {
        return this.raProperties.getJgroupsChannelRefName();
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.raProperties.setJgroupsChannelRefName(jgroupsChannelRefName);
    }

    public synchronized ActiveMQConnectionFactory getConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        boolean known = false;
        if (!this.knownConnectionFactories.keySet().contains(overrideProperties)) {
            cf = this.newConnectionFactory(overrideProperties);
            this.knownConnectionFactories.put(overrideProperties, (Pair<ActiveMQConnectionFactory, AtomicInteger>)new Pair((Object)cf, (Object)new AtomicInteger(1)));
        } else {
            Pair<ActiveMQConnectionFactory, AtomicInteger> pair = this.knownConnectionFactories.get(overrideProperties);
            cf = (ActiveMQConnectionFactory)pair.getA();
            ((AtomicInteger)pair.getB()).incrementAndGet();
            known = true;
        }
        if (known && cf.getServerLocator().isClosed()) {
            this.knownConnectionFactories.remove(overrideProperties);
            cf = this.newConnectionFactory(overrideProperties);
            this.knownConnectionFactories.put(overrideProperties, (Pair<ActiveMQConnectionFactory, AtomicInteger>)new Pair((Object)cf, (Object)new AtomicInteger(1)));
        }
        return cf;
    }

    public ActiveMQConnectionFactory newConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        BroadcastEndpointFactory endpointFactory;
        Boolean ha;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        Boolean bl = ha = overrideProperties.isHA() != null ? overrideProperties.isHA() : this.getHA();
        if (ha == null) {
            ha = false;
        }
        if ((endpointFactory = this.createBroadcastEndpointFactory(overrideProperties)) != null) {
            Long initialTimeout;
            Long refreshTimeout;
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory(endpointFactory);
            logger.debug("Creating Connection Factory on the resource adapter for discovery={} with ha={}", (Object)groupConfiguration, (Object)ha);
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else if (connectorClassName != null) {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    logger.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Creating Connection Factory on the resource adapter for transport={} with ha={}", (Object)Arrays.toString(transportConfigurations), (Object)ha);
            }
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        } else {
            throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
        }
        cf.setUseTopologyForLoadBalancing(this.raProperties.isUseTopologyForLoadBalancing());
        cf.setEnableSharedClientID(true);
        cf.setEnable1xPrefixes(overrideProperties.isEnable1xPrefixes() != null ? overrideProperties.isEnable1xPrefixes() : (this.raProperties.isEnable1xPrefixes() == null ? false : this.raProperties.isEnable1xPrefixes()));
        this.setParams(cf, overrideProperties);
        return cf;
    }

    public ActiveMQConnectionFactory createRecoveryActiveMQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        List<String> connectorClassName;
        List<String> list = connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        if (connectorClassName == null) {
            Long initialTimeout;
            Long refreshTimeout;
            BroadcastEndpointFactory endpointFactory = this.createBroadcastEndpointFactory(overrideProperties);
            if (endpointFactory == null) {
                throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory(endpointFactory);
            groupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
            logger.debug("Creating Recovery Connection Factory on the resource adapter for discovery={}", (Object)groupConfiguration);
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    logger.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Creating Recovery Connection Factory on the resource adapter for transport={}", (Object)Arrays.toString(transportConfigurations));
            }
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        }
        this.setParams(cf, overrideProperties);
        cf.setReconnectAttempts(0);
        cf.setInitialConnectAttempts(0);
        cf.setEnable1xPrefixes(this.raProperties.isEnable1xPrefixes() == null ? false : this.raProperties.isEnable1xPrefixes());
        cf.setEnableSharedClientID(true);
        return cf;
    }

    protected BroadcastEndpointFactory createBroadcastEndpointFactory(ConnectionFactoryProperties overrideProperties) {
        String jgroupsFileName;
        String discoveryAddress;
        String string = discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        if (discoveryAddress != null) {
            Integer discoveryPort;
            Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
            if (discoveryPort == null) {
                discoveryPort = 9876;
            }
            String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
            return new UDPBroadcastEndpointFactory().setGroupAddress(discoveryAddress).setGroupPort(discoveryPort.intValue()).setLocalBindAddress(localBindAddress).setLocalBindPort(-1);
        }
        String jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        String jgroupsLocatorClassName = this.raProperties.getJgroupsChannelLocatorClass();
        if (jgroupsLocatorClassName != null) {
            String jchannelRefName = this.raProperties.getJgroupsChannelRefName();
            JChannel jchannel = ActiveMQRaUtils.locateJGroupsChannel(jgroupsLocatorClassName, jchannelRefName);
            return new ChannelBroadcastEndpointFactory(jchannel, jgroupsChannel);
        }
        String string2 = jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        if (jgroupsFileName != null) {
            return new JGroupsFileBroadcastEndpointFactory().setChannelName(jgroupsChannel).setFile(jgroupsFileName);
        }
        return null;
    }

    public Map<String, Object> overrideConnectionParameters(Map<String, Object> connectionParams, Map<String, Object> overrideConnectionParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (connectionParams != null) {
            map.putAll(connectionParams);
        }
        if (overrideConnectionParams != null) {
            for (Map.Entry<String, Object> stringObjectEntry : overrideConnectionParams.entrySet()) {
                map.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        return map;
    }

    private void setParams(ActiveMQConnectionFactory cf, ConnectionFactoryProperties overrideProperties) {
        String val5;
        Double val4;
        Long val3;
        Integer val2;
        Boolean val;
        Boolean bl = val = overrideProperties.isAutoGroup() != null ? overrideProperties.isAutoGroup() : this.raProperties.isAutoGroup();
        if (val != null) {
            cf.setAutoGroup(val.booleanValue());
        }
        Boolean bl2 = val = overrideProperties.isBlockOnAcknowledge() != null ? overrideProperties.isBlockOnAcknowledge() : this.raProperties.isBlockOnAcknowledge();
        if (val != null) {
            cf.setBlockOnAcknowledge(val.booleanValue());
        }
        Boolean bl3 = val = overrideProperties.isBlockOnNonDurableSend() != null ? overrideProperties.isBlockOnNonDurableSend() : this.raProperties.isBlockOnNonDurableSend();
        if (val != null) {
            cf.setBlockOnNonDurableSend(val.booleanValue());
        }
        Boolean bl4 = val = overrideProperties.isBlockOnDurableSend() != null ? overrideProperties.isBlockOnDurableSend() : this.raProperties.isBlockOnDurableSend();
        if (val != null) {
            cf.setBlockOnDurableSend(val.booleanValue());
        }
        Boolean bl5 = val = overrideProperties.isPreAcknowledge() != null ? overrideProperties.isPreAcknowledge() : this.raProperties.isPreAcknowledge();
        if (val != null) {
            cf.setPreAcknowledge(val.booleanValue());
        }
        Boolean bl6 = val = overrideProperties.isUseGlobalPools() != null ? overrideProperties.isUseGlobalPools() : this.raProperties.isUseGlobalPools();
        if (val != null) {
            cf.setUseGlobalPools(val.booleanValue());
        }
        Boolean bl7 = val = overrideProperties.isCacheLargeMessagesClient() != null ? overrideProperties.isCacheLargeMessagesClient() : this.raProperties.isCacheLargeMessagesClient();
        if (val != null) {
            cf.setCacheLargeMessagesClient(val.booleanValue());
        }
        Boolean bl8 = val = overrideProperties.isCompressLargeMessage() != null ? overrideProperties.isCompressLargeMessage() : this.raProperties.isCompressLargeMessage();
        if (val != null) {
            cf.setCompressLargeMessage(val.booleanValue());
        }
        Boolean bl9 = val = overrideProperties.isCacheDestinations() != null ? overrideProperties.isCacheDestinations() : this.raProperties.isCacheDestinations();
        if (val != null) {
            cf.setCacheDestinations(val.booleanValue());
        }
        Integer n = val2 = overrideProperties.getConsumerMaxRate() != null ? overrideProperties.getConsumerMaxRate() : this.raProperties.getConsumerMaxRate();
        if (val2 != null) {
            cf.setConsumerMaxRate(val2.intValue());
        }
        Integer n2 = val2 = overrideProperties.getConsumerWindowSize() != null ? overrideProperties.getConsumerWindowSize() : this.raProperties.getConsumerWindowSize();
        if (val2 != null) {
            cf.setConsumerWindowSize(val2.intValue());
        }
        Integer n3 = val2 = overrideProperties.getDupsOKBatchSize() != null ? overrideProperties.getDupsOKBatchSize() : this.raProperties.getDupsOKBatchSize();
        if (val2 != null) {
            cf.setDupsOKBatchSize(val2.intValue());
        }
        Integer n4 = val2 = overrideProperties.getMinLargeMessageSize() != null ? overrideProperties.getMinLargeMessageSize() : this.raProperties.getMinLargeMessageSize();
        if (val2 != null) {
            cf.setMinLargeMessageSize(val2.intValue());
        }
        Integer n5 = val2 = overrideProperties.getProducerMaxRate() != null ? overrideProperties.getProducerMaxRate() : this.raProperties.getProducerMaxRate();
        if (val2 != null) {
            cf.setProducerMaxRate(val2.intValue());
        }
        Integer n6 = val2 = overrideProperties.getProducerWindowSize() != null ? overrideProperties.getProducerWindowSize() : this.raProperties.getProducerWindowSize();
        if (val2 != null) {
            cf.setProducerWindowSize(val2.intValue());
        }
        Integer n7 = val2 = overrideProperties.getConfirmationWindowSize() != null ? overrideProperties.getConfirmationWindowSize() : this.raProperties.getConfirmationWindowSize();
        if (val2 != null) {
            cf.setConfirmationWindowSize(val2.intValue());
        }
        Integer n8 = val2 = overrideProperties.getReconnectAttempts() != null ? overrideProperties.getReconnectAttempts() : this.raProperties.getReconnectAttempts();
        if (val2 != null) {
            cf.setReconnectAttempts(val2.intValue());
        } else {
            cf.setReconnectAttempts(-1);
        }
        Integer n9 = val2 = overrideProperties.getThreadPoolMaxSize() != null ? overrideProperties.getThreadPoolMaxSize() : this.raProperties.getThreadPoolMaxSize();
        if (val2 != null) {
            cf.setThreadPoolMaxSize(val2.intValue());
        }
        Integer n10 = val2 = overrideProperties.getScheduledThreadPoolMaxSize() != null ? overrideProperties.getScheduledThreadPoolMaxSize() : this.raProperties.getScheduledThreadPoolMaxSize();
        if (val2 != null) {
            cf.setScheduledThreadPoolMaxSize(val2.intValue());
        }
        Integer n11 = val2 = overrideProperties.getTransactionBatchSize() != null ? overrideProperties.getTransactionBatchSize() : this.raProperties.getTransactionBatchSize();
        if (val2 != null) {
            cf.setTransactionBatchSize(val2.intValue());
        }
        Integer n12 = val2 = overrideProperties.getInitialConnectAttempts() != null ? overrideProperties.getInitialConnectAttempts() : this.raProperties.getInitialConnectAttempts();
        if (val2 != null) {
            cf.setInitialConnectAttempts(val2.intValue());
        }
        Integer n13 = val2 = overrideProperties.getInitialMessagePacketSize() != null ? overrideProperties.getInitialMessagePacketSize() : this.raProperties.getInitialMessagePacketSize();
        if (val2 != null) {
            cf.setInitialMessagePacketSize(val2.intValue());
        }
        Integer n14 = val2 = overrideProperties.getCompressionLevel() != null ? overrideProperties.getCompressionLevel() : this.raProperties.getCompressionLevel();
        if (val2 != null) {
            cf.setCompressionLevel(val2.intValue());
        }
        Long l = val3 = overrideProperties.getClientFailureCheckPeriod() != null ? overrideProperties.getClientFailureCheckPeriod() : this.raProperties.getClientFailureCheckPeriod();
        if (val3 != null) {
            cf.setClientFailureCheckPeriod(val3.longValue());
        }
        Long l2 = val3 = overrideProperties.getCallTimeout() != null ? overrideProperties.getCallTimeout() : this.raProperties.getCallTimeout();
        if (val3 != null) {
            cf.setCallTimeout(val3.longValue());
        }
        Long l3 = val3 = overrideProperties.getCallFailoverTimeout() != null ? overrideProperties.getCallFailoverTimeout() : this.raProperties.getCallFailoverTimeout();
        if (val3 != null) {
            cf.setCallFailoverTimeout(val3.longValue());
        }
        Long l4 = val3 = overrideProperties.getConnectionTTL() != null ? overrideProperties.getConnectionTTL() : this.raProperties.getConnectionTTL();
        if (val3 != null) {
            cf.setConnectionTTL(val3.longValue());
        }
        Long l5 = val3 = overrideProperties.getRetryInterval() != null ? overrideProperties.getRetryInterval() : this.raProperties.getRetryInterval();
        if (val3 != null) {
            cf.setRetryInterval(val3.longValue());
        }
        Long l6 = val3 = overrideProperties.getMaxRetryInterval() != null ? overrideProperties.getMaxRetryInterval() : this.raProperties.getMaxRetryInterval();
        if (val3 != null) {
            cf.setMaxRetryInterval(val3.longValue());
        }
        Double d = val4 = overrideProperties.getRetryIntervalMultiplier() != null ? overrideProperties.getRetryIntervalMultiplier() : this.raProperties.getRetryIntervalMultiplier();
        if (val4 != null) {
            cf.setRetryIntervalMultiplier(val4.doubleValue());
        }
        String string = val5 = overrideProperties.getClientID() != null ? overrideProperties.getClientID() : this.raProperties.getClientID();
        if (val5 != null) {
            cf.setClientID(val5);
        }
        String string2 = val5 = overrideProperties.getConnectionLoadBalancingPolicyClassName() != null ? overrideProperties.getConnectionLoadBalancingPolicyClassName() : this.raProperties.getConnectionLoadBalancingPolicyClassName();
        if (val5 != null) {
            cf.setConnectionLoadBalancingPolicyClassName(val5);
        }
        String string3 = val5 = overrideProperties.getProtocolManagerFactoryStr() != null ? overrideProperties.getProtocolManagerFactoryStr() : this.raProperties.getProtocolManagerFactoryStr();
        if (val5 != null) {
            cf.setProtocolManagerFactoryStr(val5);
        }
        String string4 = val5 = overrideProperties.getDeserializationBlackList() != null ? overrideProperties.getDeserializationBlackList() : this.raProperties.getDeserializationBlackList();
        if (val5 != null) {
            cf.setDeserializationBlackList(val5);
        }
        String string5 = val5 = overrideProperties.getDeserializationWhiteList() != null ? overrideProperties.getDeserializationWhiteList() : this.raProperties.getDeserializationWhiteList();
        if (val5 != null) {
            cf.setDeserializationWhiteList(val5);
        }
        cf.setIgnoreJTA(this.isIgnoreJTA().booleanValue());
    }

    public void setManagedConnectionFactory(ActiveMQRAManagedConnectionFactory activeMQRAManagedConnectionFactory) {
        this.managedConnectionFactories.add(activeMQRAManagedConnectionFactory);
    }

    public String getCodec() {
        return this.raProperties.getCodec();
    }

    public synchronized void closeConnectionFactory(ConnectionFactoryProperties properties) {
        Pair<ActiveMQConnectionFactory, AtomicInteger> pair = this.knownConnectionFactories.get(properties);
        int references = ((AtomicInteger)pair.getB()).decrementAndGet();
        if (pair.getA() != null && pair.getA() != this.defaultActiveMQConnectionFactory && references == 0) {
            ((ActiveMQConnectionFactory)this.knownConnectionFactories.remove(properties).getA()).close();
        }
    }

    public Boolean isIgnoreJTA() {
        return this.ignoreJTA;
    }

    public void setIgnoreJTA(Boolean ignoreJTA) {
        this.ignoreJTA = ignoreJTA;
    }
}

