/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedCommandBuilder;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.terminal.utils.Config;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.aesh.SynopsisGenerator;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.activator.DomainOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.StandaloneOptionActivator;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HelpSupport {
    private static final String TAB = "    ";
    private static final String OPTION_PREFIX = "--";
    private static final String OPTION_SUFFIX = "  - ";
    public static final String NULL_DESCRIPTION = "WARNING: No Description. Please Fix it";
    static final Map<Class<?>, String> VALUES = new HashMap();
    private static boolean testMode;

    public static void printHelp(CommandContext ctx) {
        ctx.printLine(HelpSupport.printHelp(ctx, HelpSupport.getLegacyHelpPath("help")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printHelp(CommandContext ctx, String filename) {
        InputStream helpInput = WildFlySecurityManager.getClassLoaderPrivileged(CommandHandlerWithHelp.class).getResourceAsStream(filename);
        if (helpInput != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput));
            try {
                String string = HelpSupport.format(ctx, reader);
                return string;
            }
            catch (IOException e) {
                String string = "Failed to read " + filename + ". " + e.getLocalizedMessage();
                return string;
            }
            finally {
                StreamUtils.safeClose((Closeable)reader);
            }
        }
        return "Failed to locate command description " + filename;
    }

    public static String getLegacyHelpPath(String commandName) {
        return "help/" + commandName + ".txt";
    }

    public static String format(CommandContext ctx, BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int width = ctx.getTerminalWidth();
        if (width <= 0) {
            width = 80;
        }
        String line = reader.readLine();
        while (line != null) {
            String next = reader.readLine();
            if (line.length() < width) {
                builder.append(line).append("\n");
            } else {
                int endLine;
                char[] offsetArr;
                int i;
                int offset = 0;
                if (next != null && !next.isEmpty()) {
                    for (i = 0; i < next.length(); ++i) {
                        if (Character.isWhitespace(next.charAt(i))) continue;
                        offset = i;
                        break;
                    }
                } else {
                    for (i = 0; i < line.length(); ++i) {
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        offset = i;
                        break;
                    }
                }
                if (offset == 0) {
                    offsetArr = null;
                } else {
                    offsetArr = new char[offset];
                    Arrays.fill(offsetArr, ' ');
                }
                for (endLine = width; endLine >= 0 && !Character.isWhitespace(line.charAt(endLine - 1)); --endLine) {
                }
                if (endLine < 0) {
                    endLine = width;
                }
                builder.append(line.substring(0, endLine)).append("\n");
                int lineIndex = endLine;
                while (lineIndex < line.length()) {
                    int startLine;
                    endLine = Math.min(startLine + width - offset, line.length());
                    for (startLine = lineIndex; startLine < endLine && Character.isWhitespace(line.charAt(startLine)); ++startLine) {
                    }
                    if (startLine == endLine) {
                        startLine = lineIndex;
                    }
                    if ((endLine = startLine + width - offset) > line.length()) {
                        endLine = line.length();
                    } else {
                        while (endLine > startLine) {
                            if (Character.isWhitespace(line.charAt(endLine - 1))) {
                                --endLine;
                                break;
                            }
                            --endLine;
                        }
                        if (endLine == startLine) {
                            endLine = Math.min(startLine + width - offset, line.length());
                        }
                    }
                    lineIndex = endLine;
                    if (offsetArr != null) {
                        StringBuilder lineBuf = new StringBuilder();
                        lineBuf.append(offsetArr);
                        lineBuf.append(line.substring(startLine, endLine));
                        builder.append(lineBuf.toString()).append("\n");
                        continue;
                    }
                    builder.append(line.substring(startLine, endLine)).append("\n");
                }
            }
            line = next;
        }
        return builder.toString();
    }

    public static Class<?> getClassFromType(ModelType mt) {
        Class clazz;
        switch (mt) {
            case BIG_DECIMAL: {
                clazz = BigDecimal.class;
                break;
            }
            case BOOLEAN: {
                clazz = Boolean.class;
                break;
            }
            case BIG_INTEGER: {
                clazz = BigInteger.class;
                break;
            }
            case BYTES: {
                clazz = byte[].class;
                break;
            }
            case DOUBLE: {
                clazz = Double.class;
                break;
            }
            case EXPRESSION: {
                clazz = Expression.class;
                break;
            }
            case INT: {
                clazz = Integer.class;
                break;
            }
            case LIST: {
                clazz = List.class;
                break;
            }
            case LONG: {
                clazz = Long.class;
                break;
            }
            case OBJECT: {
                clazz = Object.class;
                break;
            }
            case PROPERTY: {
                clazz = Property.class;
                break;
            }
            case STRING: {
                clazz = String.class;
                break;
            }
            case TYPE: {
                clazz = ModelType.class;
                break;
            }
            default: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    public static String printHelp(CommandContext ctx, ModelNode mn, OperationRequestAddress address) {
        try {
            String commandName = mn.get("operation-name").asString();
            Object desc = mn.get("description").asString();
            desc = (String)desc + Config.getLineSeparator() + Config.getLineSeparator() + "NB: to retrieve operation full description call the following operation: " + HelpSupport.buildAddress(address) + ":read-operation-description(name=" + commandName + ")";
            ModelNode props = mn.get("request-properties");
            ProcessedCommand pcommand = ProcessedCommandBuilder.builder().name(commandName).description((String)desc).create();
            for (String prop : props.keys()) {
                ModelNode p = props.get(prop);
                Class<?> clazz = HelpSupport.getClassFromType(HelpSupport.getAdaptedArgumentType(p));
                boolean required = p.hasDefined("required") ? p.get("required").asBoolean() : false;
                ProcessedOption opt = ProcessedOptionBuilder.builder().name(prop).required(required).hasValue(true).description(HelpSupport.buildOperationArgumentDescription(p)).type(clazz).build();
                pcommand.addOption(opt);
            }
            String content = HelpSupport.getCommandHelp(null, Collections.emptyList(), null, Collections.emptyList(), pcommand.getOptions(), pcommand, null, commandName, pcommand, true);
            if (mn.hasDefined("reply-properties")) {
                ModelNode reply = mn.get("reply-properties");
                StringBuilder builder = new StringBuilder();
                builder.append(content);
                builder.append("RETURN VALUE");
                builder.append(Config.getLineSeparator());
                builder.append(Config.getLineSeparator());
                if (reply.hasDefined("type")) {
                    builder.append(reply.get("type").asString()).append(". ");
                }
                if (reply.hasDefined("description")) {
                    builder.append(reply.get("description").asString());
                }
                builder.append(Config.getLineSeparator());
                builder.append(Config.getLineSeparator());
                content = builder.toString();
            }
            return content;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String buildOperationArgumentDescription(ModelNode p) {
        StringBuilder builder = new StringBuilder();
        builder.append(HelpSupport.buildOperationArgumentType(p)).append(", ");
        builder.append(p.get("description").asString());
        if (p.hasDefined("value-type")) {
            ModelNode vt;
            boolean isList;
            boolean bl = isList = p.get("type").asType() == ModelType.LIST;
            if (isList) {
                builder.append(" List items are ");
            }
            if (HelpSupport.isObject(vt = p.get("value-type"))) {
                if (isList) {
                    builder.append("OBJECT instances with the following properties:").append(Config.getLineSeparator());
                } else {
                    builder.append("OBJECT properties:").append(Config.getLineSeparator());
                }
                for (String prop : vt.keys()) {
                    ModelNode mn = vt.get(prop);
                    builder.append(Config.getLineSeparator()).append("- ").append(prop).append(": ").append(HelpSupport.buildOperationArgumentType(mn)).append(", ").append(HelpSupport.getAdaptedArgumentDescription(mn));
                    builder.append(Config.getLineSeparator());
                }
            } else {
                builder.append(vt.asType());
            }
        }
        return builder.toString();
    }

    private static String buildAddress(OperationRequestAddress address) {
        StringBuilder builder = new StringBuilder();
        if (address != null && !address.isEmpty()) {
            for (OperationRequestAddress.Node node : address) {
                builder.append("/" + node.getType() + "=" + node.getName());
            }
        }
        return builder.toString();
    }

    private static String buildOperationArgumentType(ModelNode p) {
        StringBuilder builder = new StringBuilder();
        ModelType mt = HelpSupport.getAdaptedArgumentType(p);
        boolean isList = mt == ModelType.LIST;
        builder.append(mt);
        boolean isObject = false;
        if (isList) {
            String t = null;
            if (p.hasDefined("value-type")) {
                ModelNode vt = p.get("value-type");
                isObject = HelpSupport.isObject(vt);
            }
            t = isObject ? "OBJECT" : p.get("value-type").asType().name();
            builder.append(" of ").append(t);
        }
        return builder.toString();
    }

    private static boolean isObject(ModelNode vt) {
        try {
            vt.asType();
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    private static ModelType getAdaptedArgumentType(ModelNode mn) {
        ModelType type = mn.get("type").asType();
        if (mn.hasDefined("filesystem-path") && mn.hasDefined("attached-streams")) {
            type = ModelType.STRING;
        }
        return type;
    }

    private static String getAdaptedArgumentDescription(ModelNode mn) {
        Object desc = mn.get("description").asString();
        if (mn.hasDefined("filesystem-path") && mn.hasDefined("attached-streams")) {
            desc = "The path to the file to attach. The CLI deals directly with file paths and doesn't require index manipulation." + Config.getLineSeparator() + "NB: The actual argument type is " + mn.get("type").asType();
        }
        return desc;
    }

    public static String getSubCommandHelp(String parentCommand, CommandLineParser<CLICommandInvocation> parser) {
        String commandName = parser.getProcessedCommand().name();
        return HelpSupport.getCommandHelp(parentCommand, commandName, parser);
    }

    public static String getCommandHelp(CommandLineParser<CLICommandInvocation> parser) {
        String commandName = parser.getProcessedCommand().name();
        return HelpSupport.getCommandHelp(null, commandName, parser);
    }

    private static String getCommandHelp(String parentName, String commandName, CommandLineParser<CLICommandInvocation> parser) {
        HashSet<String> deprecated = new HashSet<String>();
        ArrayList<String> superNames = new ArrayList<String>();
        HelpSupport.retrieveDeprecated(deprecated, parser.getCommand().getClass(), superNames);
        HelpSupport.retrieveHidden(deprecated, (ProcessedCommand<Command<CLICommandInvocation>, CLICommandInvocation>)parser.getProcessedCommand());
        List parsers = parser.getAllChildParsers();
        ResourceBundle bundle = HelpSupport.getBundle(parser.getCommand());
        ProcessedCommand pcommand = HelpSupport.retrieveDescriptions(bundle, parentName, parser.getProcessedCommand(), superNames, deprecated);
        ArrayList<ProcessedOption> opts = new ArrayList<ProcessedOption>();
        for (ProcessedOption o : pcommand.getOptions()) {
            if (deprecated.contains(o.name())) continue;
            opts.add(o);
        }
        Collections.sort(opts, (o1, o2) -> o1.name().compareTo(o2.name()));
        ProcessedOption arg = deprecated.contains("") ? null : (pcommand.getArgument() == null ? pcommand.getArguments() : pcommand.getArgument());
        return HelpSupport.getCommandHelp(bundle, superNames, arg, parsers, opts, pcommand, parentName, commandName, parser.getProcessedCommand(), false);
    }

    private static String getCommandHelp(ResourceBundle bundle, List<String> superNames, ProcessedOption arg, List<CommandLineParser<CLICommandInvocation>> parsers, List<ProcessedOption> opts, ProcessedCommand<?, ?> pcommand, String parentName, String commandName, ProcessedCommand<?, ?> origCommand, boolean isOperation) {
        StringBuilder builder = new StringBuilder();
        builder.append(Config.getLineSeparator());
        builder.append("SYNOPSIS").append(Config.getLineSeparator());
        builder.append(Config.getLineSeparator());
        String synopsis = HelpSupport.getValue(bundle, parentName, commandName, superNames, "synopsis", true);
        StringBuilder tabBuilder = new StringBuilder();
        if (parentName != null) {
            tabBuilder.append(parentName).append(" ");
        }
        tabBuilder.append(commandName).append(" ");
        StringBuilder synopsisTab = new StringBuilder();
        for (int i = 0; i < tabBuilder.toString().length() + TAB.length(); ++i) {
            synopsisTab.append(" ");
        }
        if (synopsis == null) {
            List<ProcessedOption> standalone = HelpSupport.retrieveNoContextOptions(opts);
            if (!(standalone.size() != opts.size() || arg != null && arg.activator() instanceof DomainOptionActivator)) {
                synopsis = HelpSupport.generateSynopsis(bundle, parentName, commandName, opts, arg, parsers != null && !parsers.isEmpty(), superNames, isOperation, false);
                builder.append(HelpSupport.splitAndFormat(synopsis, 80, TAB, 0, synopsisTab.toString()));
            } else {
                List<ProcessedOption> standaloneOnly = HelpSupport.retrieveStandaloneOptions(opts);
                builder.append("Standalone mode:").append(Config.getLineSeparator());
                builder.append(Config.getLineSeparator());
                synopsis = HelpSupport.generateSynopsis(bundle, parentName, commandName, standaloneOnly, arg, parsers != null && !parsers.isEmpty(), superNames, isOperation, false);
                builder.append(HelpSupport.splitAndFormat(synopsis, 80, TAB, 0, synopsisTab.toString()));
                builder.append(Config.getLineSeparator());
                builder.append(Config.getLineSeparator());
                builder.append("Domain mode:").append(Config.getLineSeparator());
                builder.append(Config.getLineSeparator());
                List<ProcessedOption> domain = HelpSupport.retrieveDomainOptions(opts);
                synopsis = HelpSupport.generateSynopsis(bundle, parentName, commandName, domain, arg, parsers != null && !parsers.isEmpty(), superNames, isOperation, true);
                builder.append(HelpSupport.splitAndFormat(synopsis, 80, TAB, 0, synopsisTab.toString()));
            }
        } else {
            builder.append(HelpSupport.splitAndFormat(synopsis, 80, TAB, 0, synopsisTab.toString()));
        }
        builder.append(Config.getLineSeparator());
        builder.append(Config.getLineSeparator());
        builder.append("DESCRIPTION").append(Config.getLineSeparator());
        builder.append(Config.getLineSeparator());
        builder.append(HelpSupport.splitAndFormat(pcommand.description(), 80, TAB, 0, TAB));
        builder.append(Config.getLineSeparator());
        if (origCommand.getAliases() != null && !origCommand.getAliases().isEmpty()) {
            builder.append("ALIASES").append(Config.getLineSeparator());
            builder.append(Config.getLineSeparator());
            for (String a : origCommand.getAliases()) {
                builder.append(TAB);
                builder.append(a).append(Config.getLineSeparator());
            }
            builder.append(Config.getLineSeparator());
        }
        builder.append(HelpSupport.printOptions(opts, arg, isOperation)).append(Config.getLineSeparator());
        builder.append(HelpSupport.printActions(bundle, parentName, commandName, parsers, superNames));
        return builder.toString();
    }

    private static String printActions(ResourceBundle bundle, String parentName, String commandName, List<CommandLineParser<CLICommandInvocation>> parsers, List<String> superNames) {
        StringBuilder builder = new StringBuilder();
        if (parsers != null && !parsers.isEmpty()) {
            builder.append("ACTIONS").append(Config.getLineSeparator()).append(Config.getLineSeparator());
            builder.append("Type \"help ").append(commandName).append(" <action>\" for more details.").append(Config.getLineSeparator()).append(Config.getLineSeparator());
            ArrayList<ProcessedCommand> actions = new ArrayList<ProcessedCommand>();
            for (CommandLineParser<CLICommandInvocation> commandLineParser : parsers) {
                ResourceBundle childBundle = HelpSupport.getBundle(commandLineParser.getCommand());
                ProcessedCommandBuilder pcBuilder = HelpSupport.retrieveDescriptionBuilder(childBundle, commandName, commandLineParser.getProcessedCommand(), superNames);
                if (pcBuilder == null) {
                    actions.add(commandLineParser.getProcessedCommand());
                    continue;
                }
                try {
                    actions.add(pcBuilder.create());
                }
                catch (CommandLineParserException ex) {
                    Logger.getLogger(HelpSupport.class).warn((Object)("Error building description " + ex));
                    if (!testMode) continue;
                    throw new RuntimeException(ex);
                }
            }
            int maxActionName = 0;
            for (ProcessedCommand pc : actions) {
                String name = HelpSupport.createActionName(pc.name(), pc.name().length());
                if (name.length() <= maxActionName) continue;
                maxActionName = name.length();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < maxActionName; ++i) {
                stringBuilder.append(" ");
            }
            String tab = stringBuilder.toString();
            Collections.sort(actions, (o1, o2) -> o1.name().compareTo(o2.name()));
            for (ProcessedCommand pc : actions) {
                String name = HelpSupport.createActionName(pc.name(), maxActionName);
                builder.append(name);
                int length = 77 - tab.length();
                String line = HelpSupport.extractFirstLine(pc.description(), length);
                builder.append(line).append("...").append(Config.getLineSeparator()).append(Config.getLineSeparator());
            }
        }
        return builder.toString();
    }

    private static void retrieveHidden(Set<String> deprecated, ProcessedCommand<Command<CLICommandInvocation>, CLICommandInvocation> cmd) {
        if (cmd.getArgument() != null && cmd.getArgument().activator() instanceof HideOptionActivator || cmd.getArguments() != null && cmd.getArguments().activator() instanceof HideOptionActivator) {
            deprecated.add("");
        }
        for (ProcessedOption po : cmd.getOptions()) {
            if (!(po.activator() instanceof HideOptionActivator)) continue;
            deprecated.add(po.name());
        }
    }

    private static void retrieveDeprecated(Set<String> deprecated, Class clazz, List<String> superNames) {
        for (Field field : clazz.getDeclaredFields()) {
            HelpSupport.processField(deprecated, field);
        }
        if (clazz.getSuperclass() != null) {
            Class sup = clazz.getSuperclass();
            if (sup.getAnnotation(CommandDefinition.class) != null) {
                CommandDefinition cd = sup.getAnnotation(CommandDefinition.class);
                superNames.add(cd.name());
            }
            if (sup.getAnnotation(GroupCommandDefinition.class) != null) {
                GroupCommandDefinition gcd = sup.getAnnotation(GroupCommandDefinition.class);
                superNames.add(gcd.name());
            }
            HelpSupport.retrieveDeprecated(deprecated, sup, superNames);
        }
    }

    private static void processField(Set<String> deprecated, Field field) {
        Deprecated dep = field.getAnnotation(Deprecated.class);
        if (dep != null) {
            Option o = field.getAnnotation(Option.class);
            if (o != null) {
                String name = o.name();
                if (name == null || name.isEmpty()) {
                    name = field.getName();
                }
                deprecated.add(name);
            } else {
                OptionList ol = field.getAnnotation(OptionList.class);
                if (ol != null) {
                    String name = ol.name();
                    if (name == null || name.isEmpty()) {
                        name = field.getName();
                    }
                    deprecated.add(name);
                } else if (field.getAnnotation(Argument.class) != null || field.getAnnotation(Arguments.class) != null) {
                    deprecated.add("");
                }
            }
        }
    }

    private static String generateSynopsis(ResourceBundle bundle, String parentName, String commandName, List<ProcessedOption> opts, ProcessedOption arg, boolean hasActions, List<String> superNames, boolean isOperation, boolean domain) {
        SynopsisGenerator generator = new SynopsisGenerator(bundle, parentName, commandName, opts, arg, hasActions, superNames, isOperation, domain);
        return generator.generateSynopsis();
    }

    private static String printOptions(List<ProcessedOption> opts, ProcessedOption arg, boolean isOperation) {
        int width = 80;
        StringBuilder sb = new StringBuilder();
        if (!opts.isEmpty()) {
            sb.append(Config.getLineSeparator()).append("OPTIONS").append(Config.getLineSeparator());
            sb.append(Config.getLineSeparator());
        }
        int maxOptionName = 0;
        for (ProcessedOption o : opts) {
            String name = HelpSupport.createOptionName(o.name(), o.name().length(), o.shortName(), isOperation);
            if (name.length() <= maxOptionName) continue;
            maxOptionName = name.length();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < maxOptionName; ++i) {
            builder.append(" ");
        }
        String tab = builder.toString();
        for (ProcessedOption o : opts) {
            String name = HelpSupport.createOptionName(o.name(), maxOptionName, o.shortName(), isOperation);
            sb.append(name);
            sb.append(HelpSupport.splitAndFormat(o.description(), width, "", name.length(), tab));
            sb.append(Config.getLineSeparator());
        }
        if (arg != null) {
            sb.append(Config.getLineSeparator()).append("ARGUMENT").append(Config.getLineSeparator());
            sb.append(Config.getLineSeparator());
            sb.append(HelpSupport.splitAndFormat(arg.description(), width, TAB, 0, TAB));
        }
        return sb.toString();
    }

    private static String createOptionName(String name, int maxOptionName, String shortName, boolean isOperation) {
        String prefix;
        if (shortName != null) {
            name = (String)name + " or (-" + shortName + ")";
        }
        StringBuilder builder = new StringBuilder((String)name);
        String string = prefix = isOperation ? "" : OPTION_PREFIX;
        while (builder.length() < maxOptionName - TAB.length() - prefix.length() - OPTION_SUFFIX.length()) {
            builder.append(" ");
        }
        return TAB + prefix + builder.toString() + OPTION_SUFFIX;
    }

    private static String createActionName(String name, int maxOptionName) {
        StringBuilder builder = new StringBuilder(name);
        while (builder.length() < maxOptionName - TAB.length() - OPTION_SUFFIX.length()) {
            builder.append(" ");
        }
        return TAB + builder.toString() + OPTION_SUFFIX;
    }

    private static ResourceBundle getBundle(Command c) {
        Class<?> clazz = c.getClass();
        String s = clazz.getPackage().getName() + ".command_resources";
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(s, Locale.getDefault(), c.getClass().getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return bundle;
    }

    static String getValue(ResourceBundle bundle, String parentName, String commandName, List<String> superNames, String key, boolean acceptNull) {
        Object k;
        if (bundle == null) {
            return null;
        }
        String value = null;
        try {
            k = parentName == null ? commandName + "." + key : parentName + "." + commandName + "." + key;
            value = bundle.getString((String)k);
        }
        catch (MissingResourceException ex) {
            for (String superName : superNames) {
                try {
                    String k2 = parentName == null ? superName + "." + key : parentName + "." + superName + "." + key;
                    value = bundle.getString(k2);
                    break;
                }
                catch (MissingResourceException ex2) {
                }
            }
        }
        if (value != null && value.startsWith("${") && value.endsWith("}")) {
            k = value.substring(2, value.length() - 1);
            try {
                value = bundle.getString((String)k);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (value == null && !acceptNull) {
            if (testMode) {
                throw new RuntimeException("Invalid help for command, no value for property " + (parentName == null ? commandName + "." + key : parentName + "." + commandName + "." + key));
            }
            value = NULL_DESCRIPTION;
        }
        return value;
    }

    private static ProcessedCommandBuilder retrieveDescriptionBuilder(ResourceBundle bundle, String parentName, ProcessedCommand<?, ?> pc, List<String> superNames) {
        if (bundle == null) {
            if (testMode) {
                throw new RuntimeException("Invalid help for command, no bundle");
            }
            return null;
        }
        String desc = pc.description();
        String bdesc = HelpSupport.getValue(bundle, parentName, pc.name(), superNames, "description", false);
        if (bdesc != null) {
            desc = bdesc;
        }
        ProcessedCommandBuilder builder = ProcessedCommandBuilder.builder().name(pc.name()).description(desc);
        return builder;
    }

    private static ProcessedCommand retrieveDescriptions(ResourceBundle bundle, String parentName, ProcessedCommand<?, ?> pc, List<String> superNames, Set<String> deprecated) {
        try {
            ProcessedOption newArg;
            String bargDesc;
            String argDesc;
            ProcessedCommandBuilder builder = HelpSupport.retrieveDescriptionBuilder(bundle, parentName, pc, superNames);
            if (builder == null) {
                return pc;
            }
            if (pc.getArgument() != null && !deprecated.contains(pc.getArgument().name())) {
                argDesc = pc.getArgument().description();
                bargDesc = HelpSupport.getValue(bundle, parentName, pc.name(), superNames, "arguments.description", false);
                if (bargDesc != null) {
                    argDesc = bargDesc;
                }
                newArg = ProcessedOptionBuilder.builder().name("").optionType(pc.getArgument().getOptionType()).type(String.class).activator(pc.getArgument().activator()).valueSeparator(pc.getArgument().getValueSeparator()).required(pc.getArgument().isRequired()).description(argDesc).build();
                builder.argument(newArg);
            } else if (pc.getArguments() != null && !deprecated.contains(pc.getArguments().name())) {
                argDesc = pc.getArguments().description();
                bargDesc = HelpSupport.getValue(bundle, parentName, pc.name(), superNames, "arguments.description", false);
                if (bargDesc != null) {
                    argDesc = bargDesc;
                }
                newArg = ProcessedOptionBuilder.builder().name("").optionType(pc.getArguments().getOptionType()).type(String.class).activator(pc.getArguments().activator()).valueSeparator(pc.getArguments().getValueSeparator()).required(pc.getArguments().isRequired()).description(argDesc).build();
                builder.argument(newArg);
            }
            for (ProcessedOption opt : pc.getOptions()) {
                if (deprecated.contains(opt.name())) continue;
                String optDesc = opt.description();
                String boptDesc = HelpSupport.getValue(bundle, parentName, pc.name(), superNames, "option." + opt.name() + ".description", false);
                if (boptDesc != null) {
                    optDesc = boptDesc;
                }
                ProcessedOption newOption = ProcessedOptionBuilder.builder().name(opt.name()).optionType(opt.getOptionType()).type(String.class).activator(opt.activator()).valueSeparator(opt.getValueSeparator()).shortName(opt.shortName() == null ? (char)'\u0000' : opt.shortName().charAt(0)).required(opt.isRequired()).description(optDesc).build();
                builder.addOption(newOption);
            }
            return builder.create();
        }
        catch (Exception ex) {
            Logger.getLogger(HelpSupport.class).warn((Object)("Error building description " + ex));
            if (testMode) {
                throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            }
            return pc;
        }
    }

    private static String extractFirstLine(String content, int width) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        if (content.length() <= width) {
            return content;
        }
        String line = null;
        StringBuilder builder = new StringBuilder();
        for (char c : content.toCharArray()) {
            if (c == '\n') {
                line = builder.toString();
                line = HelpSupport.removeLastBlanks(line);
                break;
            }
            builder.append(c);
            if (builder.length() != width) continue;
            line = builder.toString();
            if (!line.endsWith(" ")) {
                int index = (line = HelpSupport.removeLastBlanks(line)).lastIndexOf(" ");
                index = index < 0 ? 0 : index;
                line = line.substring(0, index);
                break;
            }
            line = builder.toString();
            line = HelpSupport.removeLastBlanks(line);
            break;
        }
        return line;
    }

    private static String splitAndFormat(String content, int width, String firstTab, int firstOffset, String otherTab) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        if (content.length() <= width - firstTab.length() - firstOffset) {
            return firstTab + content + "\n";
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (char c : content.toCharArray()) {
            if (c == '\n') {
                builder.append(first ? firstTab : otherTab);
                String line = b.toString();
                line = HelpSupport.removeLastBlanks(line);
                builder.append(line);
                builder.append("\n");
                b = new StringBuilder();
                first = false;
                continue;
            }
            b.append(c);
            String tab = first ? firstTab : otherTab;
            if (b.length() != width - tab.length() - (first ? firstOffset : 0)) continue;
            builder.append(tab);
            String line = b.toString();
            if (!line.endsWith(" ")) {
                int index = (line = HelpSupport.removeLastBlanks(line)).lastIndexOf(" ");
                index = index < 0 ? 0 : index;
                String remain = line.substring(index);
                remain = remain.trim();
                builder.append(line.substring(0, index));
                builder.append("\n");
                b = new StringBuilder();
                b.append(remain);
                first = false;
                continue;
            }
            builder.append(HelpSupport.removeLastBlanks(line));
            builder.append("\n");
            b = new StringBuilder();
            first = false;
        }
        if (b.length() > 0) {
            builder.append(first ? firstTab : otherTab);
            String line = b.toString();
            line = HelpSupport.removeLastBlanks(line);
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    private static String removeLastBlanks(String line) {
        int num = 0;
        for (int i = line.length() - 1; i > 0 && line.charAt(i) == ' '; --i) {
            ++num;
        }
        return line.substring(0, line.length() - num);
    }

    private static List<ProcessedOption> retrieveNoContextOptions(List<ProcessedOption> opts) {
        ArrayList<ProcessedOption> standalone = new ArrayList<ProcessedOption>();
        for (ProcessedOption opt : opts) {
            if (opt.activator() instanceof DomainOptionActivator || opt.activator() instanceof StandaloneOptionActivator) continue;
            standalone.add(opt);
        }
        return standalone;
    }

    private static List<ProcessedOption> retrieveStandaloneOptions(List<ProcessedOption> opts) {
        ArrayList<ProcessedOption> standalone = new ArrayList<ProcessedOption>();
        for (ProcessedOption opt : opts) {
            if (opt.activator() instanceof DomainOptionActivator) continue;
            standalone.add(opt);
        }
        return standalone;
    }

    private static List<ProcessedOption> retrieveDomainOptions(List<ProcessedOption> opts) {
        ArrayList<ProcessedOption> domain = new ArrayList<ProcessedOption>();
        for (ProcessedOption opt : opts) {
            if (!(opt.activator() instanceof DomainOptionActivator) && opt.activator() instanceof StandaloneOptionActivator) continue;
            domain.add(opt);
        }
        return domain;
    }

    static void testMode(boolean mode) {
        testMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCommand(CommandLineParser<CLICommandInvocation> parent, CommandLineParser<CLICommandInvocation> child) throws Exception {
        boolean currentMode = testMode;
        HelpSupport.testMode(true);
        try {
            String string = parent == null ? HelpSupport.getCommandHelp(child) : HelpSupport.getSubCommandHelp(parent.getProcessedCommand().name(), child);
        }
        finally {
            HelpSupport.testMode(currentMode);
        }
    }

    static {
        VALUES.put(BigDecimal.class, "a big decimal");
        VALUES.put(Boolean.class, "true|false");
        VALUES.put(BigInteger.class, "a big integer");
        VALUES.put(byte[].class, "bytes array");
        VALUES.put(Double.class, "a double");
        VALUES.put(Expression.class, "an expression");
        VALUES.put(Integer.class, "an integer");
        VALUES.put(List.class, "a list");
        VALUES.put(Long.class, "a long");
        VALUES.put(Object.class, "an object");
        VALUES.put(Property.class, "a property");
        VALUES.put(String.class, "a string");
        VALUES.put(ModelType.class, "a type");
        testMode = false;
    }

    private static class Expression {
        private Expression() {
        }
    }
}

