/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.iiop;

import jakarta.ejb.EJBObject;
import jakarta.ejb.Handle;
import jakarta.ejb.spi.HandleDelegate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class HandleImplIIOP
implements Handle,
Serializable {
    private static final long serialVersionUID = -601170775289648475L;
    private String ior;
    private transient Class<?> stubClass = EJBObject.class;

    public HandleImplIIOP(String ior) {
        this.ior = ior;
    }

    public HandleImplIIOP(EJBObject obj) {
        this((Object)obj);
    }

    public HandleImplIIOP(Object obj) {
        this.ior = this.getOrb().object_to_string(obj);
        this.stubClass = obj.getClass();
    }

    public EJBObject getEJBObject() throws RemoteException {
        try {
            Object obj = this.getOrb().string_to_object(this.ior);
            return this.narrow(obj);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("Could not get EJBObject from Handle", e);
        }
    }

    private EJBObject narrow(Object obj) throws ClassCastException, RemoteException {
        if (obj == null) {
            return null;
        }
        if (this.stubClass.isAssignableFrom(obj.getClass())) {
            return (EJBObject)obj;
        }
        if (this.stubClass == EJBObject.class) {
            return (EJBObject)PortableRemoteObject.narrow((java.lang.Object)obj, EJBObject.class);
        }
        try {
            Stub stub = (Stub)this.stubClass.newInstance();
            stub._set_delegate(((ObjectImpl)obj)._get_delegate());
            return (EJBObject)stub;
        }
        catch (Exception e) {
            throw new RemoteException("Error creating stub", e);
        }
    }

    private void writeObject(ObjectOutputStream oostream) throws IOException {
        HandleDelegate delegate = this.getHandleDelegate();
        delegate.writeEJBObject(this.getEJBObject(), oostream);
    }

    private void readObject(ObjectInputStream oistream) throws IOException, ClassNotFoundException {
        EJBObject obj = this.getHandleDelegate().readEJBObject(oistream);
        this.ior = this.getOrb().object_to_string((Object)obj);
        this.stubClass = obj.getClass();
    }

    private HandleDelegate getHandleDelegate() {
        try {
            return (HandleDelegate)new InitialContext().lookup("java:comp/HandleDelegate");
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private ORB getOrb() {
        try {
            return (ORB)new InitialContext().lookup("java:comp/ORB");
        }
        catch (NamingException e) {
            try {
                return (ORB)new InitialContext().lookup("java:jboss/ORB");
            }
            catch (NamingException namingException) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandleImplIIOP that = (HandleImplIIOP)o;
        return !(this.ior != null ? !this.ior.equals(that.ior) : that.ior != null);
    }

    public int hashCode() {
        return this.ior != null ? this.ior.hashCode() : 0;
    }
}

