/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public interface ServiceDependency<V>
extends Dependency<RequirementServiceBuilder<?>, V> {
    default public <R> ServiceDependency<R> map(final Function<V, R> mapper) {
        return new ServiceDependency<R>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                ServiceDependency.this.accept(builder);
            }

            public R get() {
                return mapper.apply(ServiceDependency.this.get());
            }
        };
    }

    public static <T> ServiceDependency<T> of(T value) {
        return value != null ? new SimpleServiceDependency<T>(value) : SimpleServiceDependency.NULL;
    }

    public static <T> ServiceDependency<T> on(ServiceName name) {
        return name != null ? new DefaultServiceDependency(name) : ServiceDependency.of(null);
    }

    public static <T> ServiceDependency<T> on(final String capabilityName, final Class<T> type, final String ... referenceNames) {
        return new AbstractServiceDependency<T>(Map.entry(capabilityName, referenceNames)){

            public Supplier<T> apply(RequirementServiceBuilder<?> builder) {
                return builder.requiresCapability(capabilityName, type, referenceNames);
            }
        };
    }

    public static <T> ServiceDependency<T> on(final NullaryServiceDescriptor<T> descriptor) {
        return new AbstractServiceDependency<T>(descriptor.resolve()){

            public Supplier<T> apply(RequirementServiceBuilder<?> builder) {
                return builder.requires(descriptor);
            }
        };
    }

    public static <T> ServiceDependency<T> on(final UnaryServiceDescriptor<T> descriptor, final String name) {
        return new AbstractServiceDependency<T>(descriptor.resolve(name)){

            public Supplier<T> apply(RequirementServiceBuilder<?> builder) {
                return builder.requires(descriptor, name);
            }
        };
    }

    public static <T> ServiceDependency<T> on(final BinaryServiceDescriptor<T> descriptor, final String parentName, final String childName) {
        return new AbstractServiceDependency<T>(descriptor.resolve(parentName, childName)){

            public Supplier<T> apply(RequirementServiceBuilder<?> builder) {
                return builder.requires(descriptor, parentName, childName);
            }
        };
    }

    public static <T> ServiceDependency<T> on(final TernaryServiceDescriptor<T> descriptor, final String ancestorName, final String parentName, final String childName) {
        return new AbstractServiceDependency<T>(descriptor.resolve(ancestorName, parentName, childName)){

            public Supplier<T> apply(RequirementServiceBuilder<?> builder) {
                return builder.requires(descriptor, ancestorName, parentName, childName);
            }
        };
    }

    public static class DefaultServiceDependency<V>
    extends Dependency.DefaultDependency<RequirementServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        DefaultServiceDependency(ServiceName name) {
            super(name);
        }
    }

    public static class SimpleServiceDependency<V>
    extends Dependency.SimpleDependency<RequirementServiceBuilder<?>, V>
    implements ServiceDependency<V> {
        static final ServiceDependency<Object> NULL = new SimpleServiceDependency<Object>(null);

        SimpleServiceDependency(V value) {
            super(value);
        }
    }

    public static abstract class AbstractServiceDependency<T>
    extends Dependency.AbstractDependency<RequirementServiceBuilder<?>, T>
    implements ServiceDependency<T> {
        private final Map.Entry<String, String[]> resolved;

        AbstractServiceDependency(Map.Entry<String, String[]> resolved) {
            this.resolved = resolved;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AbstractServiceDependency)) {
                return false;
            }
            Map.Entry<String, String[]> resolved = ((AbstractServiceDependency)object).resolved;
            return this.resolved.getKey().equals(resolved.getKey()) && Arrays.equals(this.resolved.getValue(), resolved.getValue());
        }

        public int hashCode() {
            int result = this.resolved.getKey().hashCode();
            for (String name : this.resolved.getValue()) {
                result = 31 * result + name.hashCode();
            }
            return result;
        }

        public String toString() {
            ServiceName name = ServiceNameFactory.parseServiceName((String)this.resolved.getKey());
            return (this.resolved.getValue().length > 0 ? name.append(this.resolved.getValue()) : name).getCanonicalName();
        }
    }
}

