/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ServerSession;
import jakarta.jms.Session;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkEvent;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.resource.adapter.jms.inflow.JmsServerSessionPool;

public class JmsServerSession
implements ServerSession,
MessageListener,
Work,
WorkListener {
    private static final Logger log = Logger.getLogger(JmsServerSession.class);
    JmsServerSessionPool pool;
    Session session;
    XASession xaSession;
    MessageEndpoint endpoint;
    TransactionManager tm;

    public JmsServerSession(JmsServerSessionPool pool) {
        this.pool = pool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup() throws Exception {
        JmsActivation activation = this.pool.getActivation();
        JmsActivationSpec spec = activation.getActivationSpec();
        Connection connection = activation.getConnection();
        XAResource xaResource = null;
        this.tm = activation.getTransactionManager();
        MessageEndpointFactory endpointFactory = activation.getMessageEndpointFactory();
        if (activation.isDeliveryTransacted) {
            if (!(connection instanceof XAConnection)) throw new Exception("Delivery is transacted, but client JMS implementation does not properly implement the necessary interfaces as described in section 8 of the JMS 1.1 specification.");
            log.debug((Object)"Delivery is transacted, and client JMS implementation properly implements jakarta.jms.XAConnection.");
            this.xaSession = ((XAConnection)connection).createXASession();
            this.session = this.xaSession.getSession();
            xaResource = this.xaSession.getXAResource();
        } else {
            this.session = connection.createSession(false, spec.getAcknowledgeModeInt());
        }
        this.endpoint = endpointFactory.createEndpoint(xaResource);
        this.session.setMessageListener((MessageListener)this);
    }

    public void teardown() {
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.xaSession != null) {
                this.xaSession.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error closing xaSession " + this.xaSession), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error closing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            int timeout = this.pool.getActivation().getActivationSpec().getTransactionTimeout();
            if (timeout > 0) {
                log.trace((Object)("Setting transactionTimeout for JMSSessionPool to " + timeout));
                this.tm.setTransactionTimeout(timeout);
            }
            this.endpoint.beforeDelivery(JmsActivation.ONMESSAGE);
            try {
                MessageListener listener = (MessageListener)this.endpoint;
                listener.onMessage(message);
            }
            finally {
                this.endpoint.afterDelivery();
            }
        }
        catch (Throwable t) {
            try {
                log.error((Object)("Unexpected error delivering message. JMSMessageID is " + message.getJMSMessageID()), t);
            }
            catch (JMSException e) {
                log.error((Object)"Unexpected error delivering message. JMSMessageID cannot be determined.", t);
            }
        }
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public void start() throws JMSException {
        JmsActivation activation = this.pool.getActivation();
        WorkManager workManager = activation.getWorkManager();
        try {
            workManager.scheduleWork((Work)this, 0L, null, (WorkListener)this);
        }
        catch (WorkException e) {
            log.error((Object)"Unable to schedule work", (Throwable)e);
            throw new JMSException("Unable to schedule work: " + e.toString());
        }
    }

    public void run() {
        this.session.run();
    }

    public void release() {
    }

    public void workAccepted(WorkEvent e) {
    }

    public void workCompleted(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workRejected(WorkEvent e) {
        this.pool.returnServerSession(this);
    }

    public void workStarted(WorkEvent e) {
    }
}

