/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.stax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.jdom.Element;
import org.jdom.Namespace;

public class JDOMNamespaceContext
implements NamespaceContext {
    private Element element;

    @Override
    public String getNamespaceURI(String prefix) {
        Namespace namespace = this.element.getNamespace(prefix);
        if (namespace == null) {
            return null;
        }
        return namespace.getURI();
    }

    @Override
    public String getPrefix(String uri) {
        return JDOMNamespaceContext.rawGetPrefix(this.element, uri);
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        ArrayList<String> prefixes = new ArrayList<String>();
        JDOMNamespaceContext.rawGetPrefixes(this.element, uri, prefixes);
        return prefixes.iterator();
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public static String rawGetPrefix(Element element, String namespaceURI) {
        if (element.getNamespaceURI().equals(namespaceURI)) {
            return element.getNamespacePrefix();
        }
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if (!ns.getURI().equals(namespaceURI)) continue;
            return ns.getPrefix();
        }
        if (element.getParentElement() != null) {
            return JDOMNamespaceContext.rawGetPrefix(element.getParentElement(), namespaceURI);
        }
        return null;
    }

    static void rawGetPrefixes(Element element, String namespaceURI, List<String> prefixes) {
        if (element.getNamespaceURI().equals(namespaceURI)) {
            prefixes.add(element.getNamespacePrefix());
        }
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if (!ns.getURI().equals(namespaceURI)) continue;
            prefixes.add(ns.getPrefix());
        }
        if (element.getParentElement() != null) {
            JDOMNamespaceContext.rawGetPrefixes(element.getParentElement(), namespaceURI, prefixes);
        }
    }
}

