/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.Normalizer;
import java.util.NoSuchElementException;

public final class Version
implements Comparable<Version>,
Serializable {
    private final String version;
    private static final int TOK_INITIAL = 0;
    private static final int TOK_PART_NUMBER = 1;
    private static final int TOK_PART_ALPHA = 2;
    private static final int TOK_SEP = 3;
    private static final int TOK_SEP_EMPTY = 4;

    boolean hasNext(long cookie) {
        return Version.cookieToEndIndex(cookie) < this.version.length();
    }

    long next(long cookie) throws IllegalArgumentException {
        int end = Version.cookieToEndIndex(cookie);
        String version = this.version;
        int length = version.length();
        assert (end < length);
        int start = end;
        int cp = version.codePointAt(start);
        int token = Version.cookieToToken(cookie);
        if (token == 1 && Version.isValidAlphaPart(cp) || token == 2 && Version.isValidNumberPart(cp)) {
            token = 4;
            end = start;
        } else if ((token == 0 || token == 3 || token == 4) && Version.isValidAlphaPart(cp)) {
            token = 2;
            end = length;
            int i = start;
            while (i < length) {
                cp = version.codePointAt(i);
                if (!Version.isValidAlphaPart(cp)) {
                    end = i;
                    break;
                }
                i = version.offsetByCodePoints(i, 1);
            }
        } else if ((token == 0 || token == 3 || token == 4) && Version.isValidNumberPart(cp)) {
            token = 1;
            end = length;
            int i = start;
            while (i < length) {
                cp = version.codePointAt(i);
                if (!Version.isValidNumberPart(cp)) {
                    end = i;
                    break;
                }
                i = version.offsetByCodePoints(i, 1);
            }
        } else if ((token == 1 || token == 2) && Version.isValidSeparator(cp)) {
            token = 3;
            end = version.offsetByCodePoints(start, 1);
        } else {
            throw new IllegalArgumentException("Invalid version code point \"" + new String(Character.toChars(cp)) + "\" at offset " + start + " of \"" + version + "\"");
        }
        if (end > 0xFFFFFFF) {
            throw new IllegalArgumentException("Version string is too long");
        }
        assert (end >= start);
        return (long)start | (long)end << 28 | (long)token << 56;
    }

    static int cookieToStartIndex(long cookie) {
        return (int)(cookie & 0xFFFFFFFL);
    }

    static int cookieToEndIndex(long cookie) {
        return (int)(cookie >> 28 & 0xFFFFFFFL);
    }

    static int cookieToToken(long cookie) {
        return (int)(cookie >> 56);
    }

    static int sepMagnitude(int codePoint) {
        switch (codePoint) {
            case 46: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 43: {
                return 3;
            }
            case 95: {
                return 4;
            }
        }
        throw new IllegalStateException();
    }

    static int compareSep(int sep1, int sep2) {
        return Integer.signum(Version.sepMagnitude(sep1) - Version.sepMagnitude(sep2));
    }

    static boolean isValidAlphaPart(int codePoint) {
        return Character.isLetter(codePoint);
    }

    static boolean isValidNumberPart(int codePoint) {
        return Character.digit(codePoint, 10) != -1;
    }

    static boolean isValidSeparator(int codePoint) {
        return codePoint == 46 || codePoint == 45 || codePoint == 43 || codePoint == 95;
    }

    int comparePart(long cookie, Version other, long otherCookie) {
        int token = Version.cookieToToken(cookie);
        int otherToken = Version.cookieToToken(otherCookie);
        int start = Version.cookieToStartIndex(cookie);
        int otherStart = Version.cookieToStartIndex(cookie);
        int end = Version.cookieToEndIndex(cookie);
        int otherEnd = Version.cookieToEndIndex(otherCookie);
        switch (token) {
            case 1: {
                if (otherToken == 2) {
                    return 1;
                }
                assert (otherToken == 1);
                int digits = this.version.codePointCount(start, end);
                int otherDigits = other.version.codePointCount(otherStart, otherEnd);
                for (int i = Math.max(digits, otherDigits) - 1; i >= 0; --i) {
                    int b;
                    int a = i >= digits ? 0 : Character.digit(this.version.codePointBefore(this.version.offsetByCodePoints(end, -i)), 10);
                    int res = Integer.signum(a - (b = i >= otherDigits ? 0 : Character.digit(other.version.codePointBefore(other.version.offsetByCodePoints(otherEnd, -i)), 10)));
                    if (res == 0) continue;
                    return res;
                }
                return Integer.signum(digits - otherDigits);
            }
            case 2: {
                if (otherToken == 1) {
                    return -1;
                }
                assert (otherToken == 2);
                int i = start;
                while (i < Math.min(end, otherEnd)) {
                    int cp = this.version.codePointAt(i);
                    int ocp = other.version.codePointAt(i);
                    assert (Version.isValidAlphaPart(cp) && Version.isValidAlphaPart(ocp));
                    int res = Integer.signum(cp - ocp);
                    if (res != 0) {
                        return res;
                    }
                    i = this.version.offsetByCodePoints(i, 1);
                }
                return Integer.signum(end - otherEnd);
            }
            case 3: {
                if (otherToken == 4) {
                    return 1;
                }
                assert (otherToken == 3);
                return Version.compareSep(this.version.codePointAt(start), other.version.codePointAt(Version.cookieToStartIndex(otherCookie)));
            }
            case 4: {
                return otherToken == 4 ? 0 : -1;
            }
        }
        throw new IllegalStateException();
    }

    private Version(String v) {
        if (v == null) {
            throw new IllegalArgumentException("Null version string");
        }
        this.version = Normalizer.normalize(v, Normalizer.Form.NFKC);
        if (!this.hasNext(0L)) {
            throw new IllegalArgumentException("Empty version string");
        }
        long cookie = this.next(0L);
        while (this.hasNext(cookie)) {
            cookie = this.next(cookie);
        }
        int lastToken = Version.cookieToToken(cookie);
        if (lastToken == 3 || lastToken == 4) {
            throw new IllegalArgumentException("Version ends with a separator");
        }
    }

    public static Version parse(String v) {
        return new Version(v);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int compareTo(Version that) {
        long cookie = 0L;
        long thatCookie = 0L;
        while (this.hasNext(cookie)) {
            cookie = this.next(cookie);
            if (that.hasNext(thatCookie)) {
                int res = this.comparePart(cookie, that, thatCookie = that.next(thatCookie));
                if (res == 0) continue;
                return res;
            }
            return 1;
        }
        return that.hasNext(thatCookie) ? -1 : 0;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)ob) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }

    Object writeReplace() {
        return new Serialized(this.toString());
    }

    static final class Serialized
    implements Serializable {
        private static final long serialVersionUID = -8720461103628158977L;
        private final String string;

        Serialized(String string) {
            this.string = string;
        }

        Object readResolve() {
            return new Version(this.string);
        }
    }

    public class Iterator {
        long cookie = 0L;

        Iterator() {
        }

        public boolean hasNext() {
            return Version.this.hasNext(this.cookie);
        }

        public void next() {
            long cookie = this.cookie;
            if (!Version.this.hasNext(cookie)) {
                throw new NoSuchElementException();
            }
            this.cookie = Version.this.next(cookie);
        }

        public int length() {
            long cookie = this.cookie;
            return Version.cookieToEndIndex(cookie) - Version.cookieToStartIndex(cookie);
        }

        public boolean isSeparator() {
            int token = Version.cookieToToken(this.cookie);
            return token == 4 || token == 3;
        }

        public boolean isPart() {
            int token = Version.cookieToToken(this.cookie);
            return token == 2 || token == 1;
        }

        public boolean isEmptySeparator() {
            return Version.cookieToToken(this.cookie) == 4;
        }

        public boolean isNonEmptySeparator() {
            return Version.cookieToToken(this.cookie) == 3;
        }

        public int getSeparatorCodePoint() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 3) {
                throw new IllegalStateException();
            }
            return Version.this.version.codePointAt(Version.cookieToStartIndex(cookie));
        }

        public boolean isAlphaPart() {
            return Version.cookieToToken(this.cookie) == 2;
        }

        public boolean isNumberPart() {
            return Version.cookieToToken(this.cookie) == 1;
        }

        public String getAlphaPart() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 2) {
                throw new IllegalStateException();
            }
            return Version.this.version.substring(Version.cookieToStartIndex(cookie), Version.cookieToEndIndex(cookie));
        }

        public String getNumberPartAsString() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 1) {
                throw new IllegalStateException();
            }
            return Version.this.version.substring(Version.cookieToStartIndex(cookie), Version.cookieToEndIndex(cookie));
        }

        public long getNumberPartAsLong() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 1) {
                throw new IllegalStateException();
            }
            long total = 0L;
            int start = Version.cookieToStartIndex(cookie);
            int end = Version.cookieToEndIndex(cookie);
            int i = start;
            while (i < end) {
                total = total * 10L + (long)Character.digit(Version.this.version.codePointAt(i), 10);
                i = Version.this.version.offsetByCodePoints(i, 1);
            }
            return total;
        }

        public int getNumberPartAsInt() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 1) {
                throw new IllegalStateException();
            }
            int total = 0;
            int start = Version.cookieToStartIndex(cookie);
            int end = Version.cookieToEndIndex(cookie);
            int i = start;
            while (i < end) {
                total = total * 10 + Character.digit(Version.this.version.codePointAt(i), 10);
                i = Version.this.version.offsetByCodePoints(i, 1);
            }
            return total;
        }

        public BigInteger getNumberPartAsBigInteger() {
            long cookie = this.cookie;
            if (Version.cookieToToken(cookie) != 1) {
                throw new IllegalStateException();
            }
            return new BigInteger(Version.this.version.substring(Version.cookieToStartIndex(cookie), Version.cookieToEndIndex(cookie)));
        }
    }
}

