/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.qpid.proton.engine.Sender;

public class AMQPFederationCommandDispatcher
implements SenderController {
    private final Sender sender;
    private final AMQPSessionCallback session;
    private final ActiveMQServer server;

    AMQPFederationCommandDispatcher(Sender sender, ActiveMQServer server, AMQPSessionCallback session) {
        this.session = session;
        this.sender = sender;
        this.server = server;
    }

    public void sendPolicy(FederationReceiveFromQueuePolicy policy) throws Exception {
        Objects.requireNonNull(policy, "Cannot encode and send a null policy instance.");
        AMQPMessage command = AMQPFederationPolicySupport.encodeQueuePolicyControlMessage(policy);
        this.sendCommand(command);
    }

    public void sendPolicy(FederationReceiveFromAddressPolicy policy) throws Exception {
        Objects.requireNonNull(policy, "Cannot encode and send a null policy instance.");
        AMQPMessage command = AMQPFederationPolicySupport.encodeAddressPolicyControlMessage(policy);
        this.sendCommand(command);
    }

    public void sendCommand(AMQPMessage command) throws Exception {
        Objects.requireNonNull(command, "Null command message is not expected and constitutes an error condition");
        command.setAddress(this.getControlLinkAddress());
        this.server.getPostOffice().route((Message)command, true);
    }

    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)this.sender.getRemoteTarget().getAddress());
        try {
            this.session.createTemporaryQueue(queueName, RoutingType.ANYCAST);
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
        }
        return (Consumer)this.session.createSender(senderContext, queueName, null, false);
    }

    @Override
    public void close() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)this.sender.getRemoteTarget().getAddress());
        try {
            this.session.removeTemporaryQueue(queueName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getControlLinkAddress() {
        return this.sender.getRemoteTarget().getAddress();
    }
}

