/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.List;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceUnitSearch {
    private static final boolean traceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();

    public static PersistenceUnitMetadata resolvePersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        int scopeSeparatorCharacter;
        if (traceEnabled) {
            JpaLogger.ROOT_LOGGER.tracef("pu search for name '%s' inside of %s", persistenceUnitName, deploymentUnit.getName());
        }
        int n = scopeSeparatorCharacter = persistenceUnitName == null ? -1 : persistenceUnitName.indexOf(35);
        if (scopeSeparatorCharacter != -1) {
            String path = persistenceUnitName.substring(0, scopeSeparatorCharacter);
            String name = persistenceUnitName.substring(scopeSeparatorCharacter + 1);
            PersistenceUnitMetadata pu = PersistenceUnitSearch.getPersistenceUnit(deploymentUnit, path, name);
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("pu search found %s", pu.getScopedPersistenceUnitName());
            }
            return pu;
        }
        PersistenceUnitMetadata name = PersistenceUnitSearch.findPersistenceUnitSupplier(deploymentUnit, persistenceUnitName);
        if (traceEnabled && name != null) {
            JpaLogger.ROOT_LOGGER.tracef("pu search found %s", name.getScopedPersistenceUnitName());
        }
        return name;
    }

    private static PersistenceUnitMetadata findPersistenceUnitSupplier(DeploymentUnit deploymentUnit, String persistenceUnitName) {
        PersistenceUnitMetadata name = PersistenceUnitSearch.findWithinDeployment(deploymentUnit, persistenceUnitName);
        if (name == null) {
            name = PersistenceUnitSearch.findWithinApplication(DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit), persistenceUnitName);
        }
        return name;
    }

    private static PersistenceUnitMetadata findWithinApplication(DeploymentUnit unit, String persistenceUnitName) {
        PersistenceUnitMetadata name;
        if (traceEnabled) {
            JpaLogger.ROOT_LOGGER.tracef("pu findWithinApplication for %s", persistenceUnitName);
        }
        if ((name = PersistenceUnitSearch.findWithinDeployment(unit, persistenceUnitName)) != null) {
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("pu findWithinApplication matched for %s", persistenceUnitName);
            }
            return name;
        }
        List resourceRoots = unit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot) || (name = PersistenceUnitSearch.findWithinLibraryJar(unit, resourceRoot, persistenceUnitName)) == null) continue;
            return name;
        }
        return null;
    }

    private static PersistenceUnitMetadata findWithinLibraryJar(DeploymentUnit unit, ResourceRoot moduleResourceRoot, String persistenceUnitName) {
        ResourceRoot deploymentRoot = moduleResourceRoot;
        PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)deploymentRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
        if (holder == null || holder.getPersistenceUnits() == null) {
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("findWithinLibraryJar checking for '%s' found no persistence units", persistenceUnitName);
            }
            return null;
        }
        PersistenceUnitSearch.ambiguousPUError(unit, persistenceUnitName, holder);
        persistenceUnitName = PersistenceUnitSearch.defaultPersistenceUnitName(persistenceUnitName, holder);
        for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("findWithinLibraryJar check '%s' against pu '%s'", persistenceUnitName, persistenceUnit.getPersistenceUnitName());
            }
            if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("findWithinLibraryJar matched '%s' against pu '%s'", persistenceUnitName, persistenceUnit.getPersistenceUnitName());
            }
            return persistenceUnit;
        }
        return null;
    }

    private static PersistenceUnitMetadata findWithinDeployment(DeploymentUnit unit, String persistenceUnitName) {
        if (traceEnabled) {
            JpaLogger.ROOT_LOGGER.tracef("pu findWithinDeployment searching for %s", persistenceUnitName);
        }
        for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)unit)) {
            PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
            if (holder == null || holder.getPersistenceUnits() == null) {
                if (!traceEnabled) continue;
                JpaLogger.ROOT_LOGGER.tracef("pu findWithinDeployment skipping empty pu holder for %s", persistenceUnitName);
                continue;
            }
            PersistenceUnitSearch.ambiguousPUError(unit, persistenceUnitName, holder);
            persistenceUnitName = PersistenceUnitSearch.defaultPersistenceUnitName(persistenceUnitName, holder);
            for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
                if (traceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("findWithinDeployment check '%s' against pu '%s'", persistenceUnitName, persistenceUnit.getPersistenceUnitName());
                }
                if (persistenceUnitName != null && persistenceUnitName.length() != 0 && !persistenceUnit.getPersistenceUnitName().equals(persistenceUnitName)) continue;
                if (traceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("findWithinDeployment matched '%s' against pu '%s'", persistenceUnitName, persistenceUnit.getPersistenceUnitName());
                }
                return persistenceUnit;
            }
        }
        return null;
    }

    private static void ambiguousPUError(DeploymentUnit unit, String persistenceUnitName, PersistenceUnitMetadataHolder holder) {
        if (holder.getPersistenceUnits().size() > 1 && (persistenceUnitName == null || persistenceUnitName.length() == 0)) {
            int numberOfDefaultPersistenceUnits = 0;
            for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
                String defaultPU = persistenceUnit.getProperties().getProperty("wildfly.jpa.default-unit");
                if (!Boolean.TRUE.toString().equals(defaultPU)) continue;
                ++numberOfDefaultPersistenceUnits;
            }
            JpaLogger.ROOT_LOGGER.tracef("checking for ambiguous persistence unit injection error, number of persistence units marked default (%s) = %d", "wildfly.jpa.default-unit", numberOfDefaultPersistenceUnits);
            if (numberOfDefaultPersistenceUnits != 1) {
                throw JpaLogger.ROOT_LOGGER.noPUnitNameSpecifiedAndMultiplePersistenceUnits(holder.getPersistenceUnits().size(), unit);
            }
        }
    }

    private static String defaultPersistenceUnitName(String persistenceUnitName, PersistenceUnitMetadataHolder holder) {
        if (persistenceUnitName == null || persistenceUnitName.length() == 0) {
            for (PersistenceUnitMetadata persistenceUnit : holder.getPersistenceUnits()) {
                String defaultPU = persistenceUnit.getProperties().getProperty("wildfly.jpa.default-unit");
                if (!Boolean.TRUE.toString().equals(defaultPU)) continue;
                persistenceUnitName = persistenceUnit.getPersistenceUnitName();
            }
        }
        return persistenceUnitName;
    }

    private static PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit current, String absolutePath, String puName) {
        String path = absolutePath.startsWith("../") ? absolutePath.substring(3) : absolutePath;
        VirtualFile parent = ((ResourceRoot)current.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getParent();
        VirtualFile resolvedPath = parent.getChild(path);
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)current));
        for (ResourceRoot resourceRoot : resourceRoots) {
            PersistenceUnitMetadataHolder holder;
            if (!resourceRoot.getRoot().equals(resolvedPath) || (holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS)) == null) continue;
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                if (traceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("getPersistenceUnit check '%s' against pu '%s'", puName, pu.getPersistenceUnitName());
                }
                if (!pu.getPersistenceUnitName().equals(puName)) continue;
                if (traceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("getPersistenceUnit matched '%s' against pu '%s'", puName, pu.getPersistenceUnitName());
                }
                return pu;
            }
        }
        throw JpaLogger.ROOT_LOGGER.persistenceUnitNotFound(absolutePath, puName, current);
    }
}

