/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import org.wildfly.security.manager.WildFlySecurityManager;

final class SecurityUtils {
    private SecurityUtils() {
    }

    static boolean getBoolean(String propertyName) {
        return SecurityUtils.getBoolean(propertyName, false);
    }

    static boolean getBoolean(String propertyName, boolean defaultValue) {
        try {
            String propertyValue = SecurityUtils.getString(propertyName);
            return propertyValue != null ? Boolean.valueOf(propertyValue) : defaultValue;
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    static int getInteger(String propertyName, int defaultValue) {
        try {
            String propertyValue = SecurityUtils.getString(propertyName);
            return propertyValue != null ? Integer.parseInt(propertyValue) : defaultValue;
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    static long getLong(String propertyName, long defaultValue) {
        try {
            String propertyValue = SecurityUtils.getString(propertyName);
            return propertyValue != null ? Long.parseLong(propertyValue) : defaultValue;
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    static String getString(String propertyName) {
        return SecurityUtils.getString(propertyName, null);
    }

    static String getString(String propertyName, String defaultValue) {
        return WildFlySecurityManager.getPropertyPrivileged((String)propertyName, (String)defaultValue);
    }
}

