/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.repository.ContentFilter;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ContentRepositoryElement;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.dmr.ModelNode;

public class ManagedDeploymentBrowseContentHandler
implements OperationStepHandler {
    protected final ContentRepository contentRepository;

    public ManagedDeploymentBrowseContentHandler(ContentRepository contentRepository) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotReadContentFromSelfContainedServer();
        }
        Resource deploymentResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItemNode = DeploymentHandlerUtil.getContentItem((Resource)deploymentResource);
        if (!DeploymentHandlerUtil.isManaged((ModelNode)contentItemNode)) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotReadContentFromUnmanagedDeployment();
        }
        byte[] deploymentHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
        ModelNode pathNode = DeploymentAttributes.DEPLOYMENT_CONTENT_PATH.resolveModelAttribute(context, operation);
        String path = pathNode.isDefined() ? pathNode.asString() : "";
        int depth = DeploymentAttributes.DEPTH.resolveModelAttribute(context, operation).asInt();
        boolean explodable = DeploymentAttributes.ARCHIVE.resolveModelAttribute(context, operation).asBoolean();
        try {
            for (ContentRepositoryElement content : this.contentRepository.listContent(deploymentHash, path, ContentFilter.Factory.createContentFilter((int)depth, (boolean)explodable))) {
                ModelNode contentNode = new ModelNode();
                contentNode.get("path").set(content.getPath());
                contentNode.get("directory").set(content.isFolder());
                if (!content.isFolder()) {
                    contentNode.get("file-size").set(content.getSize());
                }
                context.getResult().add(contentNode);
            }
        }
        catch (ExplodedContentException ex) {
            throw new OperationFailedException(ex.getMessage());
        }
    }
}

