/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.manager;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.PropertyFormatter;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.Util;
import org.infinispan.counter.impl.factory.StrongCounterFactory;
import org.infinispan.counter.impl.factory.WeakCounterFactory;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.counter.impl.manager.CounterConfigurationManager;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.counter.logging.Log;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.util.concurrent.CompletionStages;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="CounterManager", description="Component to manage counters")
public class EmbeddedCounterManager
implements CounterManager {
    public static final String OBJECT_NAME = "CounterManager";
    private static final Log log = (Log)LogFactory.getLog(EmbeddedCounterManager.class, Log.class);
    private final Map<String, CompletableFuture<InternalCounterAdmin>> counters = new ConcurrentHashMap<String, CompletableFuture<InternalCounterAdmin>>(32);
    private volatile boolean stopped = true;
    @Inject
    CounterConfigurationManager configurationManager;
    @Inject
    CounterManagerNotificationManager notificationManager;
    @Inject
    StrongCounterFactory strongCounterFactory;
    @Inject
    WeakCounterFactory weakCounterFactory;

    @Start
    public void start() {
        if (log.isTraceEnabled()) {
            log.trace("Starting EmbeddedCounterManager");
        }
        this.stopped = false;
    }

    @Stop(priority=9)
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace("Stopping EmbeddedCounterManager");
        }
        this.stopped = true;
    }

    @ManagedOperation(description="Removes the counter's value from the cluster. The counter will be re-created when access next time.", displayName="Remove Counter", name="remove")
    public void remove(String counterName) {
        Util.awaitCounterOperation(this.removeAsync(counterName, true));
    }

    public CompletionStage<Void> removeAsync(String counterName, boolean keepConfig) {
        CompletionStage removeStage = this.getConfigurationAsync(counterName).thenCompose(config -> {
            if (config == null) {
                return CompletableFutures.completedNull();
            }
            CompletionStage existingCounter = this.counters.remove(counterName);
            if (existingCounter != null) {
                return existingCounter.thenCompose(InternalCounterAdmin::destroy);
            }
            if (config.type() == CounterType.WEAK) {
                return this.weakCounterFactory.removeWeakCounter(counterName, (CounterConfiguration)config);
            }
            return this.strongCounterFactory.removeStrongCounter(counterName);
        });
        if (keepConfig) {
            return removeStage;
        }
        return removeStage.thenCompose(unused -> this.configurationManager.removeConfiguration(counterName)).thenApply(CompletableFutures.toNullFunction());
    }

    public void undefineCounter(String counterName) {
        Util.awaitCounterOperation(this.removeAsync(counterName, false));
    }

    public StrongCounter getStrongCounter(String name) {
        return Util.awaitCounterOperation(this.getStrongCounterAsync(name));
    }

    public CompletionStage<StrongCounter> getStrongCounterAsync(String counterName) {
        return this.getOrCreateAsync(counterName).thenApply(InternalCounterAdmin::asStrongCounter);
    }

    public WeakCounter getWeakCounter(String name) {
        return Util.awaitCounterOperation(this.getWeakCounterAsync(name));
    }

    public CompletionStage<WeakCounter> getWeakCounterAsync(String counterName) {
        return this.getOrCreateAsync(counterName).thenApply(InternalCounterAdmin::asWeakCounter);
    }

    public CompletionStage<InternalCounterAdmin> getOrCreateAsync(String counterName) {
        if (this.stopped) {
            return CompletableFutures.completedExceptionFuture((Throwable)Log.CONTAINER.counterManagerNotStarted());
        }
        CompletableFuture stage = this.counters.computeIfAbsent(counterName, this::createCounter);
        if (CompletionStages.isCompletedSuccessfully((CompletionStage)stage)) {
            return stage;
        }
        stage.exceptionally(throwable -> {
            this.counters.remove(counterName, stage);
            return null;
        });
        return stage;
    }

    @ManagedOperation(description="Returns a collection of defined counter's name.", displayName="Get Defined Counters", name="counters")
    public Collection<String> getCounterNames() {
        return this.configurationManager.getCounterNames();
    }

    public CompletableFuture<Boolean> defineCounterAsync(String name, CounterConfiguration configuration) {
        return this.configurationManager.defineConfiguration(name, configuration);
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        return Util.awaitCounterOperation(this.defineCounterAsync(name, configuration));
    }

    public boolean isDefined(String name) {
        return Util.awaitCounterOperation(this.isDefinedAsync(name));
    }

    public CounterConfiguration getConfiguration(String counterName) {
        return Util.awaitCounterOperation(this.getConfigurationAsync(counterName));
    }

    public CompletableFuture<CounterConfiguration> getConfigurationAsync(String name) {
        return this.configurationManager.getConfiguration(name);
    }

    @ManagedOperation(description="Returns the current counter's value", displayName="Get Counter' Value", name="value")
    public long getValue(String counterName) {
        return (Long)Util.awaitCounterOperation(this.getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::value));
    }

    @ManagedOperation(description="Resets the counter's value", displayName="Reset Counter", name="reset")
    public void reset(String counterName) {
        Util.awaitCounterOperation(this.getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::reset));
    }

    @ManagedOperation(description="Returns the counter's configuration", displayName="Counter Configuration", name="configuration")
    public Properties getCounterConfiguration(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.CONTAINER.undefinedCounter(counterName);
        }
        return PropertyFormatter.getInstance().format(configuration);
    }

    public CompletableFuture<Boolean> isDefinedAsync(String name) {
        return this.getConfigurationAsync(name).thenApply(Objects::nonNull);
    }

    private CompletableFuture<InternalCounterAdmin> createCounter(String counterName) {
        return this.getConfigurationAsync(counterName).thenCompose(config -> {
            if (config == null) {
                return CompletableFutures.completedExceptionFuture((Throwable)Log.CONTAINER.undefinedCounter(counterName));
            }
            switch (config.type()) {
                case WEAK: {
                    return this.weakCounterFactory.createWeakCounter(counterName, (CounterConfiguration)config);
                }
                case BOUNDED_STRONG: 
                case UNBOUNDED_STRONG: {
                    return this.strongCounterFactory.createStrongCounter(counterName, (CounterConfiguration)config);
                }
            }
            return CompletableFutures.completedExceptionFuture((Throwable)new IllegalStateException("[should never happen] unknown counter type: " + String.valueOf(config.type())));
        });
    }
}

