/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.HttpMethodSpec;
import jakarta.security.jacc.URLPatternSpec;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;

public final class WebResourcePermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private transient HttpMethodSpec methodSpec;
    private transient URLPatternSpec urlPatternSpec;
    private transient int hashCodeValue;
    private static final transient String EMPTY_STRING = "";
    private static final transient String ESCAPED_COLON = "%3A";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};

    public WebResourcePermission(String name, String actions) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.methodSpec = HttpMethodSpec.getSpec(actions);
    }

    public WebResourcePermission(String urlPatternSpec, String[] HTTPMethods) {
        super(urlPatternSpec);
        this.urlPatternSpec = new URLPatternSpec(urlPatternSpec);
        this.methodSpec = HttpMethodSpec.getSpec(HTTPMethods);
    }

    public WebResourcePermission(HttpServletRequest request) {
        super(WebResourcePermission.getUriMinusContextPath(request));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.methodSpec = HttpMethodSpec.getSpec(request.getMethod());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)o;
        if (!this.methodSpec.equals(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(that.urlPatternSpec);
    }

    @Override
    public String getActions() {
        return this.methodSpec.getActions();
    }

    @Override
    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String hashInput = this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode();
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)permission;
        if (!this.methodSpec.implies(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(that.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        int contextLength;
        String uri = request.getRequestURI();
        if (uri == null) {
            return EMPTY_STRING;
        }
        String contextPath = request.getContextPath();
        int n = contextLength = contextPath == null ? 0 : contextPath.length();
        if (contextLength > 0) {
            uri = uri.substring(contextLength);
        }
        if (uri.equals("/")) {
            return EMPTY_STRING;
        }
        return uri.replaceAll(":", ESCAPED_COLON);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.methodSpec = HttpMethodSpec.getSpec((String)inputStream.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.putFields().put("actions", this.getActions());
        outputStream.writeFields();
    }
}

