/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.partitionhandling.impl.LostDataCheck;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.Messages;

public class PreferAvailabilityStrategy
implements AvailabilityStrategy {
    private static final Log log = LogFactory.getLog(PreferAvailabilityStrategy.class);
    private final EventLogManager eventLogManager;
    private final PersistentUUIDManager persistentUUIDManager;
    private final LostDataCheck lostDataCheck;

    public PreferAvailabilityStrategy(EventLogManager eventLogManager, PersistentUUIDManager persistentUUIDManager, LostDataCheck lostDataCheck) {
        this.eventLogManager = eventLogManager;
        this.persistentUUIDManager = persistentUUIDManager;
        this.lostDataCheck = lostDataCheck;
    }

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.remove(leaver);
        if (newMembers.isEmpty()) {
            log.debugf("The last node of cache %s left", context.getCacheName());
            context.updateCurrentTopology(newMembers);
            return;
        }
        if (context.getStableTopology() != null && this.lostDataCheck.test(context.getStableTopology().getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.lostDataBecauseOfGracefulLeaver(leaver));
        }
        context.updateCurrentTopology(newMembers);
        if (!context.restartConflictResolution(newMembers)) {
            context.queueRebalance(newMembers);
        }
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s did not lose any members, skipping rebalance", context.getCacheName());
            }
            return;
        }
        this.checkForLostData(context.getCacheName(), context.getStableTopology(), newMembers);
        if (!context.restartConflictResolution(newMembers)) {
            context.updateCurrentTopology(newMembers);
            context.queueRebalance(newMembers);
        }
    }

    private void checkForLostData(String cacheName, CacheTopology stableTopology, List<Address> newMembers) {
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.lostDataCheck.test(stableTopology.getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(cacheName).fatal(EventLogCategory.CLUSTER, Messages.MESSAGES.lostDataBecauseOfAbruptLeavers(lostMembers));
        } else if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
            this.eventLogManager.getEventLogger().context(cacheName).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.minorityPartition(newMembers, lostMembers, stableMembers));
        }
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Map<Address, CacheStatusResponse> statusResponseMap) {
        CacheTopology mergedTopology;
        boolean resolveConflicts;
        String cacheName = context.getCacheName();
        List<Address> newMembers = context.getExpectedMembers();
        List<Partition> partitions = this.computePartitions(statusResponseMap, cacheName);
        if (partitions.size() == 0) {
            log.debugf("No current topology, recovered only joiners for cache %s", cacheName);
            context.updateCurrentTopology(newMembers);
            context.queueRebalance(newMembers);
            return;
        }
        if (partitions.size() == 1) {
            Partition p = partitions.get(0);
            log.debugf("Recovered a single partition for cache %s: %s", cacheName, p.topology);
            List<Address> survivingMembers = new ArrayList<Address>(newMembers);
            if (survivingMembers.retainAll(p.readCH.getMembers())) {
                this.checkForLostData(cacheName, p.stableTopology, survivingMembers);
            }
            CacheTopology mergedTopology2 = new CacheTopology(p.topology.getTopologyId() + 1, p.topology.getRebalanceId() + 1, p.readCH, null, null, CacheTopology.Phase.NO_REBALANCE, survivingMembers, this.persistentUUIDManager.mapAddresses(survivingMembers));
            context.updateTopologiesAfterMerge(mergedTopology2, p.stableTopology, null);
            if (survivingMembers.isEmpty()) {
                survivingMembers = newMembers;
            }
            if (!survivingMembers.equals(p.topology.getMembers())) {
                context.updateCurrentTopology(survivingMembers);
            }
            context.queueRebalance(newMembers);
            return;
        }
        Partition preferredPartition = this.selectPreferredPartition(partitions);
        int mergeTopologyId = 0;
        int mergeRebalanceId = 0;
        for (Partition p : partitions) {
            CacheTopology topology = p.topology;
            if (mergeTopologyId <= topology.getTopologyId()) {
                mergeTopologyId = topology.getTopologyId() + 1;
            }
            if (mergeRebalanceId > topology.getRebalanceId()) continue;
            mergeRebalanceId = topology.getRebalanceId() + 1;
        }
        HashSet<Address> possibleOwners = new HashSet<Address>();
        HashSet<ConsistentHash> distinctHashes = new HashSet<ConsistentHash>();
        for (Partition p : partitions) {
            possibleOwners.addAll(p.readCH.getMembers());
            distinctHashes.add(p.readCH);
        }
        possibleOwners.retainAll(newMembers);
        boolean bl = resolveConflicts = context.resolveConflictsOnMerge() && possibleOwners.size() > 1;
        if (log.isTraceEnabled()) {
            log.tracef("Cache %s, resolveConflicts=%s, newMembers=%s, possibleOwners=%s, preferredTopology=%s, mergeTopologyId=%s", new Object[]{cacheName, resolveConflicts, newMembers, possibleOwners, preferredPartition.topology, mergeTopologyId});
        }
        ArrayList<Address> actualMembers = new ArrayList<Address>(newMembers);
        if (resolveConflicts) {
            actualMembers.retainAll(possibleOwners);
            ConsistentHash conflictHash = context.calculateConflictHash(preferredPartition.readCH, distinctHashes, actualMembers);
            mergedTopology = new CacheTopology(mergeTopologyId, mergeRebalanceId, conflictHash, null, CacheTopology.Phase.CONFLICT_RESOLUTION, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
        } else {
            actualMembers.retainAll(preferredPartition.readCH.getMembers());
            for (Partition p : partitions) {
                if (p == preferredPartition) continue;
                log.ignoringCacheTopology(p.senders, p.topology);
            }
            mergedTopology = new CacheTopology(mergeTopologyId, mergeRebalanceId, preferredPartition.readCH, null, CacheTopology.Phase.NO_REBALANCE, actualMembers, this.persistentUUIDManager.mapAddresses(actualMembers));
        }
        context.updateTopologiesAfterMerge(mergedTopology, preferredPartition.stableTopology, null);
        if (!actualMembers.containsAll(preferredPartition.readCH.getMembers())) {
            this.checkForLostData(cacheName, preferredPartition.stableTopology, actualMembers);
        }
        assert (!actualMembers.isEmpty());
        context.updateCurrentTopology(actualMembers);
        if (resolveConflicts) {
            context.queueConflictResolution(mergedTopology, new HashSet<Address>(preferredPartition.readCH.getMembers()));
        } else {
            context.queueRebalance(newMembers);
        }
    }

    private Partition selectPreferredPartition(List<Partition> partitions) {
        Partition preferredPartition = null;
        for (Partition p : partitions) {
            if (p.isConflictResolutionOnly() || !p.isPreferable(preferredPartition)) continue;
            preferredPartition = p;
        }
        assert (preferredPartition != null);
        return preferredPartition;
    }

    public CacheTopology computePreferredTopology(Map<Address, CacheStatusResponse> statusResponseMap) {
        List<Partition> partitions = this.computePartitions(statusResponseMap, "");
        return partitions.size() != 0 ? this.selectPreferredPartition(partitions).topology : null;
    }

    private List<Partition> computePartitions(Map<Address, CacheStatusResponse> statusResponseMap, String cacheName) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (Map.Entry<Address, CacheStatusResponse> e : statusResponseMap.entrySet()) {
            Address sender = e.getKey();
            CacheStatusResponse response = e.getValue();
            CacheTopology topology = response.getCacheTopology();
            if (topology == null || !topology.getMembers().contains(sender)) continue;
            ConsistentHash readCH = AvailabilityStrategy.ownersConsistentHash(topology, response.getCacheJoinInfo().getConsistentHashFactory());
            Partition p = new Partition(sender, topology, response.getStableTopology(), readCH, statusResponseMap.keySet());
            if (p.actualMembers.isEmpty()) continue;
            partitions.add(p);
        }
        partitions.sort((p1, p2) -> p2.topology.getTopologyId() - p1.topology.getTopologyId());
        for (int i = 0; i < partitions.size(); ++i) {
            Partition referencePartition = (Partition)partitions.get(i);
            if (log.isTraceEnabled()) {
                log.tracef("Cache %s keeping partition from %s: %s", cacheName, referencePartition.senders, referencePartition.topology);
            }
            for (int j = i + 1; j < partitions.size(); ++j) {
                Partition p = (Partition)partitions.get(j);
                if (!InfinispanCollections.containsAny(p.readCH.getMembers(), referencePartition.readCH.getMembers())) continue;
                boolean fold = false;
                int referenceTopologyId = referencePartition.topology.getTopologyId();
                int topologyId = p.topology.getTopologyId();
                if (topologyId == referenceTopologyId) {
                    if (p.topology.equals(referencePartition.topology)) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Cache %s ignoring topology from %s, same as topology from %s: %s", new Object[]{cacheName, p.senders, referencePartition.senders, p.topology});
                        }
                        fold = true;
                    } else if (log.isTraceEnabled()) {
                        log.tracef("Cache %s partition of %s overlaps with partition of %s, with the same topology id", cacheName, p.senders, referencePartition.senders);
                    }
                } else if (!this.lostDataCheck.test(p.readCH, referencePartition.actualMembers)) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Cache %s ignoring compatible old topology from %s: %s", cacheName, p.senders, p.topology);
                    }
                    fold = true;
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef("Cache %s partition of %s overlaps with partition of %s but possibly holds extra entries", cacheName, p.senders, referencePartition.senders);
                    }
                    p.setConflictResolutionOnly();
                }
                if (!fold) continue;
                referencePartition.senders.addAll(p.senders);
                partitions.remove(j);
                --j;
            }
        }
        return partitions;
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context, AvailabilityMode newAvailabilityMode) {
    }

    private static class Partition {
        final CacheTopology topology;
        final CacheTopology stableTopology;
        final ConsistentHash readCH;
        final List<Address> actualMembers;
        final List<Address> actualReadOwners;
        final List<Address> senders = new ArrayList<Address>();
        private boolean conflictResolutionOnly;

        Partition(Address sender, CacheTopology topology, CacheTopology stableTopology, ConsistentHash readCH, Collection<Address> newMembers) {
            this.topology = topology;
            this.stableTopology = stableTopology;
            this.readCH = readCH;
            this.actualMembers = new ArrayList<Address>(topology.getActualMembers());
            this.actualMembers.retainAll(newMembers);
            this.actualReadOwners = new ArrayList<Address>(readCH.getMembers());
            this.actualReadOwners.retainAll(newMembers);
            this.senders.add(sender);
        }

        private boolean isPreferable(Partition other) {
            if (other == null) {
                return true;
            }
            if (other.senders.size() < this.senders.size()) {
                return true;
            }
            if (other.senders.size() == this.senders.size() && other.actualReadOwners.size() < this.actualReadOwners.size()) {
                return true;
            }
            if (other.senders.size() == this.senders.size() && other.actualReadOwners.size() == this.actualReadOwners.size() && other.actualMembers.size() < this.actualMembers.size()) {
                return true;
            }
            return other.topology.getTopologyId() < this.topology.getTopologyId();
        }

        boolean isConflictResolutionOnly() {
            return this.conflictResolutionOnly;
        }

        void setConflictResolutionOnly() {
            this.conflictResolutionOnly = true;
        }
    }
}

