/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.RetryableException;
import jakarta.resource.spi.ValidatingManagedConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityDecrementer;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutFIFODecrementer;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.FillRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Messages;

public class SemaphoreArrayListManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private boolean fifo;
    private boolean poolValidationLoggingEnabled;
    private int maxSize;
    private ArrayList<ConnectionListener> cls;
    private final ConcurrentMap<ConnectionListener, ConnectionListener> clPermits = new ConcurrentHashMap<ConnectionListener, ConnectionListener>();
    private final ArrayList<ConnectionListener> checkedOut = new ArrayList();
    private Boolean supportsLazyAssociation;
    private long lastIdleCheck;
    private long lastUsed;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("ConnectionManager is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.cm = cm;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.fifo = p.isFIFO();
        this.log = this.pool.getLogger();
        this.poolValidationLoggingEnabled = !PoolConfiguration.getPoolsWithDisabledValidationLogging().contains(this.pool.getName());
        this.debug = this.log.isDebugEnabled();
        this.cls = new ArrayList(this.maxSize);
        this.supportsLazyAssociation = null;
        this.lastIdleCheck = System.currentTimeMillis();
        this.lastUsed = Long.MAX_VALUE;
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getInitialSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, pc.getInitialSize()));
        }
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            if (this.debug) {
                this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            }
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isRunning() {
        return !this.pool.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() == 0 && this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActive() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSize(int size) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size() >= size;
        }
    }

    @Override
    public void prefill() {
        if (this.isRunning() && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, this.poolConfiguration.getMinSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.log.isTraceEnabled()) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method = "getConnection(" + subject + ", " + cri + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.pool.getInternalStatistics(), subject, cri));
            }
        } else if (this.debug) {
            String method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        subject = subject == null ? this.defaultSubject : subject;
        ConnectionRequestInfo connectionRequestInfo = cri = cri == null ? this.defaultCri : cri;
        if (this.pool.isFull()) {
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaWaitCount();
            }
            if (this.pool.isSharable() && (this.supportsLazyAssociation == null || this.supportsLazyAssociation.booleanValue())) {
                if (this.supportsLazyAssociation == null) {
                    this.checkLazyAssociation();
                }
                if (this.supportsLazyAssociation != null && this.supportsLazyAssociation.booleanValue()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.tracef("Trying to detach - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                    if (!this.detachConnectionListener()) {
                        this.log.tracef("Detaching didn't succeed - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
                    }
                }
            }
        }
        long startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
        try {
            if (this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                ConnectionListener cl = null;
                do {
                    if (!this.isRunning()) {
                        this.pool.getLock().release();
                        throw new ResourceException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                    }
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        if (this.cls.size() > 0) {
                            cl = this.fifo ? this.cls.remove(0) : this.cls.remove(this.cls.size() - 1);
                            this.checkedOut.add(cl);
                        }
                    }
                    if (cl == null) continue;
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
                        boolean valid = true;
                        if (matchedMC != null) {
                            block65: {
                                if (this.poolConfiguration.isValidateOnMatch()) {
                                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                                        try {
                                            ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                                            Set candidateSet = Collections.singleton(cl.getManagedConnection());
                                            candidateSet = vcf.getInvalidConnections(candidateSet);
                                            if (candidateSet != null && candidateSet.size() > 0) {
                                                valid = false;
                                            }
                                            break block65;
                                        }
                                        catch (Throwable t) {
                                            valid = false;
                                            if (this.log.isTraceEnabled()) {
                                                this.log.trace("Exception while ValidateOnMatch: " + t.getMessage(), t);
                                            }
                                            break block65;
                                        }
                                    }
                                    this.log.validateOnMatchNonCompliantManagedConnectionFactory(this.mcf.getClass().getName());
                                }
                            }
                            if (valid) {
                                this.log.tracef("supplying ManagedConnection from pool: %s", cl);
                                this.clPermits.put(cl, cl);
                                this.lastUsed = System.currentTimeMillis();
                                cl.setLastCheckedOutTime(this.lastUsed);
                                if (this.pool.getInternalStatistics().isEnabled()) {
                                    this.pool.getInternalStatistics().deltaTotalGetTime(this.lastUsed - startWait);
                                    this.pool.getInternalStatistics().deltaTotalPoolTime(this.lastUsed - cl.getLastReturnedTime());
                                }
                                if (Tracer.isEnabled()) {
                                    Tracer.getConnectionListener(this.pool.getName(), this, cl, true, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                                }
                                return cl;
                            }
                        }
                        if (valid) {
                            this.log.destroyingConnectionNotSuccessfullyMatched(cl);
                        } else if (this.poolValidationLoggingEnabled) {
                            this.log.destroyingConnectionNotValidated(cl);
                        }
                        ArrayList<ConnectionListener> arrayList2 = this.cls;
                        synchronized (arrayList2) {
                            this.checkedOut.remove(cl);
                        }
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                        }
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        cl.destroy();
                        cl = null;
                    }
                    catch (Throwable t) {
                        this.log.throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(cl, t);
                        ArrayList<ConnectionListener> arrayList3 = this.cls;
                        synchronized (arrayList3) {
                            this.checkedOut.remove(cl);
                        }
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                        }
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        cl.destroy();
                        cl = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    if (!this.log.isTraceEnabled()) break;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.cls.size() > 0);
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (Tracer.isEnabled()) {
                        Tracer.createConnectionListener(this.pool.getName(), this, cl, cl.getManagedConnection(), true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    ArrayList<ConnectionListener> t = this.cls;
                    synchronized (t) {
                        this.checkedOut.add(cl);
                    }
                    this.log.tracef("supplying new ManagedConnection: %s", cl);
                    this.clPermits.put(cl, cl);
                    this.lastUsed = System.currentTimeMillis();
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaTotalGetTime(this.lastUsed - startWait);
                    }
                    this.prefill();
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this, subject, cri));
                    }
                    if (Tracer.isEnabled()) {
                        Tracer.getConnectionListener(this.pool.getName(), this, cl, false, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    return cl;
                }
                catch (Throwable t) {
                    if (cl != null || !(t instanceof RetryableException)) {
                        this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    }
                    if (cl != null) {
                        ArrayList<ConnectionListener> arrayList = this.cls;
                        synchronized (arrayList) {
                            this.checkedOut.remove(cl);
                        }
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        cl.destroy();
                    }
                    this.pool.getLock().release();
                    if (t instanceof ResourceException) {
                        throw (ResourceException)t;
                    }
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaBlockingFailureCount();
            }
            throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            long end = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() - startWait : 0L;
            this.pool.getInternalStatistics().deltaTotalBlockingTime(end);
            throw new ResourceException(bundle.interruptedWhileRequestingPermit(end));
        }
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc) {
        return this.findConnectionListener(mc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object connection) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            for (ConnectionListener cl : this.checkedOut) {
                if (!cl.controls(mc, connection)) continue;
                return cl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(ConnectionListener cl) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            this.cls.add(cl);
        }
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaCreatedCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener removeConnectionListener() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            if (this.cls.size() > 0) {
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaDestroyedCount();
                }
                return this.cls.remove(0);
            }
        }
        return null;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        this.returnConnection(cl, kill, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionListener cl, boolean kill, boolean cleanup) {
        ArrayList<ConnectionListener> arrayList;
        if (this.pool.getInternalStatistics().isEnabled() && cl.getState() != ConnectionState.DESTROYED) {
            this.pool.getInternalStatistics().deltaTotalUsageTime(System.currentTimeMillis() - cl.getLastCheckedOutTime());
        }
        if (this.log.isTraceEnabled()) {
            arrayList = this.cls;
            synchronized (arrayList) {
                String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        if (cl.getState() == ConnectionState.DESTROYED) {
            this.log.tracef("ManagedConnection is being returned after it was destroyed: %s", cl);
            ConnectionListener present = (ConnectionListener)this.clPermits.remove(cl);
            if (present != null) {
                this.pool.getLock().release();
            }
            return;
        }
        if (cleanup) {
            try {
                cl.getManagedConnection().cleanup();
            }
            catch (ResourceException re) {
                this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
                kill = true;
            }
        }
        if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        if (kill) {
            arrayList = this.cls;
            synchronized (arrayList) {
                this.checkedOut.remove(cl);
                this.cls.remove(cl);
                if (this.clPermits.remove(cl) != null) {
                    this.pool.getLock().release();
                }
            }
        }
        cl.toPool();
        arrayList = this.cls;
        synchronized (arrayList) {
            this.checkedOut.remove(cl);
            if (!this.cls.contains(cl)) {
                this.cls.add(cl);
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
            if (this.clPermits.remove(cl) != null) {
                this.pool.getLock().release();
            }
        }
        if (kill) {
            this.log.tracef("Destroying returned connection %s", cl);
            if (Tracer.isEnabled()) {
                Tracer.destroyConnectionListener(this.pool.getName(), this, cl, true, false, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
            }
            cl.destroy();
            cl = null;
            this.prefill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(FlushMode mode, Collection<ConnectionListener> toDestroy) {
        ArrayList<Object> keep = null;
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            Object cl;
            if (FlushMode.ALL == mode) {
                this.log.tracef("Flushing pool checkedOut=%s inPool=%s", this.checkedOut, this.cls);
                while (this.checkedOut.size() > 0) {
                    cl = this.checkedOut.remove(0);
                    this.log.tracef("Flush marking checked out connection for destruction %s", cl);
                    cl.setState(ConnectionState.DESTROY);
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaTotalUsageTime(System.currentTimeMillis() - cl.getLastCheckedOutTime());
                    }
                    toDestroy.add((ConnectionListener)cl);
                    ConnectionListener present = (ConnectionListener)this.clPermits.remove(cl);
                    if (present == null) continue;
                    this.pool.getLock().release();
                }
            } else if (FlushMode.GRACEFULLY == mode) {
                this.log.tracef("Gracefully flushing pool checkedOut=%s inPool=%s", this.checkedOut, this.cls);
                for (ConnectionListener cl2 : this.checkedOut) {
                    this.log.tracef("Graceful flush marking checked out connection for destruction %s", cl2);
                    cl2.setState(ConnectionState.DESTROY);
                }
            }
            while (this.cls.size() > 0) {
                cl = this.cls.remove(0);
                boolean kill = true;
                if (FlushMode.INVALID == mode && cl.getState().equals((Object)ConnectionState.NORMAL) && this.mcf instanceof ValidatingManagedConnectionFactory) {
                    try {
                        ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        Set candidateSet = Collections.singleton(cl.getManagedConnection());
                        candidateSet = vcf.getInvalidConnections(candidateSet);
                        if (candidateSet == null || candidateSet.size() == 0) {
                            kill = false;
                        }
                    }
                    catch (Throwable t) {
                        this.log.trace("Exception during invalid flush", t);
                    }
                }
                if (kill) {
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                    }
                    cl.setState(ConnectionState.DESTROY);
                    toDestroy.add((ConnectionListener)cl);
                    continue;
                }
                if (keep == null) {
                    keep = new ArrayList<Object>(1);
                }
                keep.add(cl);
            }
            if (keep != null) {
                this.cls.addAll(keep);
            }
        }
        this.prefill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        Object method;
        long now = System.currentTimeMillis();
        long timeoutSetting = (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L;
        CapacityDecrementer decrementer = this.pool.getCapacity().getDecrementer();
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        if (TimedOutDecrementer.class.getName().equals(decrementer.getClass().getName()) || TimedOutFIFODecrementer.class.getName().equals(decrementer.getClass().getName()) ? now < this.lastIdleCheck + 60000L : now < this.lastIdleCheck + timeoutSetting) {
            return;
        }
        this.lastIdleCheck = now;
        ArrayList<ConnectionListener> destroyConnections = new ArrayList<ConnectionListener>();
        long timeout = now - timeoutSetting;
        boolean destroy = true;
        int destroyed = 0;
        if (this.log.isTraceEnabled()) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method2 = "removeIdleConnections(" + timeout + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method2, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            method = "removeIdleConnections(" + timeout + ")";
            this.log.debug(ManagedConnectionPoolUtility.details((String)method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        while (destroy) {
            method = this.cls;
            synchronized (method) {
                if (this.cls.size() == 0) {
                    break;
                }
                ConnectionListener cl = this.cls.get(0);
                destroy = decrementer.shouldDestroy(cl, timeout, this.cls.size() + this.checkedOut.size(), this.poolConfiguration.getMinSize(), destroyed);
                if (destroy) {
                    if (this.shouldRemove() || !this.isRunning()) {
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaTimedOut();
                        }
                        this.log.tracef("Idle connection cl=%s", cl);
                        this.cls.remove(0);
                        destroyConnections.add(cl);
                        ++destroyed;
                    } else {
                        destroy = false;
                    }
                }
            }
        }
        if (destroyConnections.size() > 0 || this.isEmpty()) {
            for (ConnectionListener cl : destroyConnections) {
                this.log.tracef("Destroying connection %s", cl);
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                }
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, true, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                cl.destroy();
                cl = null;
            }
            if (this.isRunning()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        this.prefill();
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<ConnectionListener> toDestroy;
        SemaphoreArrayListManagedConnectionPool semaphoreArrayListManagedConnectionPool = this;
        synchronized (semaphoreArrayListManagedConnectionPool) {
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
            }
            IdleRemover.getInstance().unregisterPool(this);
            ConnectionValidator.getInstance().unregisterPool(this);
            if (this.checkedOut.size() > 0) {
                for (ConnectionListener cl : this.checkedOut) {
                    this.log.destroyingActiveConnection(this.pool.getName(), cl.getManagedConnection());
                    if (!Tracer.isEnabled()) continue;
                    Tracer.clearConnectionListener(this.pool.getName(), this, cl);
                }
            }
            toDestroy = new ArrayList<ConnectionListener>();
            this.flush(FlushMode.ALL, toDestroy);
        }
        for (ConnectionListener cl : toDestroy) {
            cl.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillTo(int size) {
        if (size <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method = "fillTo(" + size + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
            }
        } else if (this.debug) {
            String method = "fillTo(" + size + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
        }
        while (!this.pool.isFull()) {
            try {
                long startWait;
                long l = startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
                if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                try {
                    if (!this.isRunning()) {
                        return;
                    }
                    if (this.isSize(size)) {
                        return;
                    }
                    ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                    if (Tracer.isEnabled()) {
                        Tracer.createConnectionListener(this.pool.getName(), this, cl, cl.getManagedConnection(), false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    boolean added = false;
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        if (!this.isSize(size)) {
                            this.log.tracef("Filling pool cl=%s", cl);
                            this.cls.add(cl);
                            added = true;
                        }
                    }
                    if (added) continue;
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, false, false, false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    cl.destroy();
                    return;
                }
                finally {
                    this.pool.getLock().release();
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                this.log.trace("Interrupted while requesting permit in fillTo");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCapacity(Subject subject, ConnectionRequestInfo cri) {
        int created = 1;
        boolean create = true;
        while (create && !this.pool.isFull()) {
            try {
                long startWait;
                long l = startWait = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
                if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                try {
                    if (!this.isRunning()) {
                        return;
                    }
                    int currentSize = 0;
                    ArrayList<ConnectionListener> arrayList = this.cls;
                    synchronized (arrayList) {
                        currentSize = this.cls.size() + this.checkedOut.size();
                    }
                    create = this.pool.getCapacity().getIncrementer().shouldCreate(currentSize, this.poolConfiguration.getMaxSize(), created);
                    if (!create) continue;
                    try {
                        ConnectionListener cl = this.createConnectionEventListener(subject, cri);
                        if (Tracer.isEnabled()) {
                            Tracer.createConnectionListener(this.pool.getName(), this, cl, cl.getManagedConnection(), false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        boolean added = false;
                        ArrayList<ConnectionListener> arrayList2 = this.cls;
                        synchronized (arrayList2) {
                            if (!this.isSize(this.poolConfiguration.getMaxSize())) {
                                this.log.tracef("Capacity fill: cl=%s", cl);
                                this.cls.add(cl);
                                ++created;
                                added = true;
                            }
                        }
                        if (added) continue;
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, true, false, false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        cl.destroy();
                        return;
                    }
                    catch (ResourceException re) {
                        this.log.unableFillPool(re, this.cm.getJndiName());
                        return;
                    }
                }
                finally {
                    this.pool.getLock().release();
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                this.log.trace("Interrupted while requesting permit in increaseCapacity");
            }
        }
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = this.pool.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaTotalCreationTime(System.currentTimeMillis() - start);
            this.pool.getInternalStatistics().deltaCreatedCount();
        }
        try {
            return this.cm.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaDestroyedCount();
            }
            mc.destroy();
            throw re;
        }
    }

    @Override
    public void connectionListenerDestroyed(ConnectionListener cl) {
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaDestroyedCount();
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin() && this.pool instanceof PrefillPool) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            this.log.tracef("StrictMin is active. Current connection will be removed is %b", remove);
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block39: {
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Attempting to  validate connections for pool %s", this);
                var1_1 = this.cls;
                synchronized (var1_1) {
                    method = "validateConnections()";
                    this.log.trace(ManagedConnectionPoolUtility.fullDetails(this, method, this.mcf, this.cm, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.pool.getInternalStatistics(), this.defaultSubject, this.defaultCri));
                }
            } else if (this.debug) {
                method = "validateConnections()";
                this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.pool.getInternalStatistics().getInUseCount(), this.maxSize));
            }
            if (!this.pool.getLock().tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) break block39;
            anyDestroyed = false;
            block23: while (true) {
                while (true) lbl-1000:
                // 3 sources

                {
                    cl = null;
                    destroyed = false;
                    var4_6 = this.cls;
                    synchronized (var4_6) {
                        if (this.cls.size() == 0) {
                            break block39;
                        }
                        cl = this.removeForFrequencyCheck();
                    }
                    if (cl == null) {
                        break block39;
                    }
                    try {
                        candidateSet = Collections.singleton(cl.getManagedConnection());
                        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                            vcf = (ValidatingManagedConnectionFactory)this.mcf;
                            if (((candidateSet = vcf.getInvalidConnections(candidateSet)) != null && candidateSet.size() > 0 || !this.isRunning()) && cl.getState() != ConnectionState.DESTROY) {
                                if (this.pool.getInternalStatistics().isEnabled()) {
                                    this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                                }
                                if (Tracer.isEnabled()) {
                                    Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() != false ? new Throwable("CALLSTACK") : null);
                                }
                                cl.destroy();
                                cl = null;
                                destroyed = true;
                                anyDestroyed = true;
                            }
                        } else {
                            this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                        }
                        if (destroyed) ** GOTO lbl-1000
                        candidateSet = this.cls;
                    }
                    catch (ResourceException re) {
                        if (cl != null) {
                            if (this.pool.getInternalStatistics().isEnabled()) {
                                this.pool.getInternalStatistics().deltaTotalPoolTime(System.currentTimeMillis() - cl.getLastReturnedTime());
                            }
                            if (Tracer.isEnabled()) {
                                Tracer.destroyConnectionListener(this.pool.getName(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() != false ? new Throwable("CALLSTACK") : null);
                            }
                            cl.destroy();
                            cl = null;
                            destroyed = true;
                            anyDestroyed = true;
                        }
                        this.log.connectionValidatorIgnoredUnexpectedError(re);
                        continue block23;
                    }
                    finally {
                        if (destroyed) continue;
                        var4_6 = this.cls;
                        synchronized (var4_6) {
                            this.returnForFrequencyCheck(cl);
                        }
                        continue block23;
                    }
                    synchronized (candidateSet) {
                        this.returnForFrequencyCheck(cl);
                        continue block23;
                    }
                    break;
                }
                break;
            }
            finally {
                this.pool.getLock().release();
                if (anyDestroyed) {
                    this.prefill();
                }
            }
        }
    }

    String getPoolName() {
        if (this.pool == null) {
            return "";
        }
        return this.pool.getName();
    }

    private ConnectionListener removeForFrequencyCheck() {
        ConnectionListener cl2 = null;
        for (ConnectionListener cl2 : this.cls) {
            long lastCheck = cl2.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationMillis()) {
                this.cls.remove(cl2);
                break;
            }
            cl2 = null;
        }
        if (this.debug) {
            this.log.debugf("Checking for connection within frequency: %s", cl2);
        }
        return cl2;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        if (this.debug) {
            this.log.debugf("Returning for connection within frequency: %s", cl);
        }
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.cls.add(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLazyAssociation() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            ConnectionListener cl = null;
            if (this.checkedOut.size() > 0) {
                cl = this.checkedOut.get(0);
            }
            if (cl == null && this.cls.size() > 0) {
                cl = this.cls.get(0);
            }
            if (cl != null) {
                if (cl.supportsLazyAssociation()) {
                    if (this.debug) {
                        this.log.debug("Enable lazy association support for: " + this.pool.getName());
                    }
                    this.supportsLazyAssociation = Boolean.TRUE;
                } else {
                    if (this.debug) {
                        this.log.debug("Disable lazy association support for: " + this.pool.getName());
                    }
                    this.supportsLazyAssociation = Boolean.FALSE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachConnectionListener() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            block9: {
                ConnectionListener cl2 = null;
                try {
                    for (ConnectionListener cl2 : this.checkedOut) {
                        if (cl2.isEnlisted() || !(cl2.getManagedConnection() instanceof DissociatableManagedConnection)) continue;
                        this.log.tracef("Detach: %s", cl2);
                        DissociatableManagedConnection dmc = (DissociatableManagedConnection)cl2.getManagedConnection();
                        dmc.dissociateConnections();
                        cl2.unregisterConnections();
                        if (Tracer.isEnabled()) {
                            Tracer.returnConnectionListener(this.pool.getName(), this, cl2, false, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.returnConnection(cl2, false, false);
                        return true;
                    }
                }
                catch (Throwable t) {
                    if (this.debug) {
                        this.log.debug("Exception during detach for: " + this.pool.getName(), t);
                    }
                    this.supportsLazyAssociation = Boolean.FALSE;
                    if (cl2 == null) break block9;
                    if (Tracer.isEnabled()) {
                        Tracer.returnConnectionListener(this.pool.getName(), this, cl2, true, this.pool.isInterleaving(), Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.returnConnection(cl2, true, true);
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SemaphoreArrayListManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }
}

