/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service.capture;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.service.capture.FunctionExecutorRegistry;
import org.wildfly.service.capture.ValueRegistry;

public interface ValueExecutorRegistry<K, V>
extends ValueRegistry<K, V>,
FunctionExecutorRegistry<K, V> {
    public static <K, V> ValueExecutorRegistry<K, V> newInstance() {
        return new ValueExecutorRegistry<K, V>(){
            private final Map<K, AtomicReference<V>> references = new ConcurrentHashMap();

            private AtomicReference<V> create(K dependency) {
                return new AtomicReference();
            }

            @Override
            public Consumer<V> add(K key) {
                AtomicReference reference = this.references.computeIfAbsent(key, this::create);
                return reference::set;
            }

            @Override
            public void remove(K key) {
                AtomicReference<Object> reference = this.references.remove(key);
                if (reference != null) {
                    reference.set(null);
                }
            }

            @Override
            public FunctionExecutor<V> getExecutor(K key) {
                AtomicReference reference = this.references.get(key);
                return reference != null ? FunctionExecutor.of(reference::get) : null;
            }
        };
    }
}

