/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.VectorSimilarityFilterQuery;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneVectorFieldCodec;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.KnnPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneKnnPredicate
extends AbstractLuceneSingleFieldPredicate
implements LuceneSearchPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final int k;
    private final Object vector;
    private final LuceneSearchPredicate filter;
    private final Float similarity;
    private final VectorSimilarityFunction similarityFunction;

    private LuceneKnnPredicate(Builder<?> builder) {
        super(builder);
        this.k = builder.k;
        this.vector = builder.vector;
        this.filter = builder.filter;
        this.similarity = builder.similarity;
        this.similarityFunction = builder.similarityFunction;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        if (this.vector instanceof byte[]) {
            byte[] byteVector = (byte[])this.vector;
            KnnByteVectorQuery query = new KnnByteVectorQuery(this.absoluteFieldPath, byteVector, this.k, this.prepareFilter(context));
            return this.similarity == null ? query : VectorSimilarityFilterQuery.create(query, this.similarity.floatValue(), byteVector.length, this.similarityFunction);
        }
        if (this.vector instanceof float[]) {
            KnnFloatVectorQuery query = new KnnFloatVectorQuery(this.absoluteFieldPath, (float[])this.vector, this.k, this.prepareFilter(context));
            return this.similarity == null ? query : VectorSimilarityFilterQuery.create(query, this.similarity.floatValue(), this.similarityFunction);
        }
        throw new UnsupportedOperationException("Unknown vector type " + this.vector.getClass() + ". only byte[] and float[] vectors are supported.");
    }

    private Query prepareFilter(PredicateRequestContext context) {
        return context.appendTenantAndRoutingFilters(this.filter == null ? null : this.filter.toQuery(context));
    }

    private static class Builder<F>
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements KnnPredicateBuilder {
        private final Class<?> vectorElementsType;
        private final int indexedVectorsDimension;
        private final VectorSimilarityFunction similarityFunction;
        private int k;
        private Object vector;
        private LuceneSearchPredicate filter;
        private Float similarity;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            LuceneFieldCodec codec = field.type().codec();
            if (!(codec instanceof LuceneVectorFieldCodec)) {
                throw new AssertionFailure("Attempting to use a knn predicate on a non-vector field.");
            }
            LuceneVectorFieldCodec vectorCodec = (LuceneVectorFieldCodec)codec;
            this.vectorElementsType = vectorCodec.vectorElementsType();
            this.indexedVectorsDimension = vectorCodec.getConfiguredDimensions();
            this.similarityFunction = vectorCodec.getVectorSimilarity();
        }

        public void k(int k) {
            this.k = k;
        }

        public void vector(Object vector) {
            if (!vector.getClass().isArray()) {
                throw new IllegalArgumentException("Vector can only be either a float or a byte array (float[], byte[]).");
            }
            if (!this.vectorElementsType.equals(vector.getClass().getComponentType())) {
                throw log.vectorKnnMatchVectorTypeDiffersFromField(this.absoluteFieldPath, this.vectorElementsType, vector.getClass().getComponentType());
            }
            if (Array.getLength(vector) != this.indexedVectorsDimension) {
                throw log.vectorKnnMatchVectorDimensionDiffersFromField(this.absoluteFieldPath, this.indexedVectorsDimension, Array.getLength(vector));
            }
            this.vector = vector;
        }

        public void filter(SearchPredicate filter) {
            this.filter = LuceneSearchPredicate.from(this.scope, filter);
        }

        public void requiredMinimumSimilarity(float similarity) {
            this.similarity = Float.valueOf(similarity);
        }

        public SearchPredicate build() {
            return new LuceneKnnPredicate(this);
        }
    }

    public static class DefaultFactory<F>
    extends AbstractLuceneValueFieldSearchQueryElementFactory<KnnPredicateBuilder, F> {
        @Override
        public KnnPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(scope, field);
        }
    }
}

