/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface LuceneSearchProjection<P>
extends SearchProjection<P> {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public Extractor<?, P> request(ProjectionRequestContext var1);

    public static <P> LuceneSearchProjection<P> from(LuceneSearchIndexScope<?> scope, SearchProjection<P> projection) {
        if (!(projection instanceof LuceneSearchProjection)) {
            throw log.cannotMixLuceneSearchQueryWithOtherProjections(projection);
        }
        LuceneSearchProjection casted = (LuceneSearchProjection)projection;
        if (!scope.hibernateSearchIndexNames().equals(casted.indexNames())) {
            throw log.projectionDefinedOnDifferentIndexes(projection, casted.indexNames(), scope.hibernateSearchIndexNames());
        }
        return casted;
    }

    public static interface Extractor<E, P> {
        public Values<E> values(ProjectionExtractContext var1);

        public P transform(LoadingResult<?> var1, E var2, ProjectionTransformContext var3);

        public static <Z> Z transformUnsafe(Extractor<?, Z> extractor, LoadingResult<?> loadingResult, Object extractedData, ProjectionTransformContext context) {
            return extractor.transform(loadingResult, extractedData, context);
        }
    }
}

