/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.infinispan;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.CompositeServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.server.service.ProvidedCacheServiceConfigurator;
import org.wildfly.clustering.server.service.group.DistributedCacheGroupServiceConfiguratorProvider;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.metadata.SessionMetaDataKey;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.common.function.Functions;

public class InfinispanSessionManagerFactoryServiceConfigurator<S, SC, AL, LC>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanSessionManagerFactoryConfiguration<S, SC, AL, LC>,
Supplier<SessionManagerFactory<SC, LC, TransactionBatch>>,
Consumer<ConfigurationBuilder> {
    private final InfinispanSessionManagementConfiguration<DeploymentUnit> configuration;
    private final SessionManagerFactoryConfiguration<S, SC, AL, LC> factoryConfiguration;
    private volatile ServiceConfigurator configurationConfigurator;
    private volatile ServiceConfigurator cacheConfigurator;
    private volatile ServiceConfigurator groupConfigurator;
    private volatile SupplierDependency<NodeFactory<Address>> group;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile Supplier<Cache> cache;

    public InfinispanSessionManagerFactoryServiceConfigurator(InfinispanSessionManagementConfiguration<DeploymentUnit> configuration, SessionManagerFactoryConfiguration<S, SC, AL, LC> factoryConfiguration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "web", factoryConfiguration.getDeploymentName()}));
        this.configuration = configuration;
        this.factoryConfiguration = factoryConfiguration;
    }

    @Override
    public SessionManagerFactory<SC, LC, TransactionBatch> get() {
        return new InfinispanSessionManagerFactory((InfinispanSessionManagerFactoryConfiguration)this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        String cacheName = this.configuration.getCacheName();
        String deploymentName = this.factoryConfiguration.getDeploymentName();
        this.configurationConfigurator = new TemplateConfigurationServiceConfigurator(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, containerName, deploymentName), containerName, deploymentName, cacheName, (Consumer)this).configure(support);
        this.cacheConfigurator = new CacheServiceConfigurator(InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, deploymentName), containerName, deploymentName).configure(support);
        this.groupConfigurator = new ProvidedCacheServiceConfigurator(DistributedCacheGroupServiceConfiguratorProvider.class, this.configuration.getContainerName(), this.factoryConfiguration.getDeploymentName()).configure(support);
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, deploymentName));
        return this;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        Integer size;
        ExpirationConfiguration expiration = builder.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder.expiration().lifespan(-1L).maxIdle(-1L);
            InfinispanWebLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(this.configuration.getContainerName(), this.configuration.getCacheName()));
        }
        EvictionStrategy strategy = (size = this.factoryConfiguration.getMaxActiveSessions()) != null ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
        builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount(size != null ? size.longValue() : 0L);
        if (strategy.isEnabled()) {
            ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
        }
        PersistenceConfiguration persistence = builder.persistence().create();
        if (size == null && persistence.passivation() && persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
            builder.persistence().passivation(false).clearStores();
        }
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder configurationBuilder = this.configurationConfigurator.build(target);
        ServiceBuilder cacheBuilder = this.cacheConfigurator.build(target);
        ServiceBuilder groupBuilder = this.groupConfigurator.build(target);
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.group, this.affinityFactory, this.dispatcherFactory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        this.cache = builder.requires(this.cacheConfigurator.getServiceName());
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, Functions.closingConsumer());
        return new CompositeServiceBuilder(List.of(configurationBuilder, cacheBuilder, groupBuilder, builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND)));
    }

    public <K, V> Cache<K, V> getCache() {
        return this.cache.get();
    }

    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }

    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.group.get();
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.factoryConfiguration.getAttributePersistenceStrategy();
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.factoryConfiguration.getMarshaller();
    }

    public Integer getMaxActiveSessions() {
        return this.factoryConfiguration.getMaxActiveSessions();
    }

    public String getServerName() {
        return this.factoryConfiguration.getServerName();
    }

    public String getDeploymentName() {
        return this.factoryConfiguration.getDeploymentName();
    }

    public Supplier<LC> getLocalContextFactory() {
        return this.factoryConfiguration.getLocalContextFactory();
    }

    public Immutability getImmutability() {
        return this.factoryConfiguration.getImmutability();
    }

    public SpecificationProvider<S, SC, AL> getSpecificationProvider() {
        return this.factoryConfiguration.getSpecificationProvider();
    }
}

