/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.wsf.spi.management.CommonConfigStore;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;

public class CommonConfigStoreImpl<T extends AbstractCommonConfig>
implements CommonConfigStore<T> {
    private final Map<String, T> configs = new HashMap<String, T>(4);
    private volatile T wrapper;
    private volatile Map<String, T> loadedConfigs = Collections.emptyMap();

    public synchronized void register(T config) {
        this.configs.put(config.getConfigName(), config);
    }

    public synchronized void unregister(T config) {
        this.configs.remove(config.getConfigName());
    }

    private T newInstance(T obj, T wrapper) {
        Class<?> clazz = obj.getClass();
        try {
            return (T)((AbstractCommonConfig)clazz.getConstructor(clazz, wrapper.getClass()).newInstance(obj, wrapper));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void reload() {
        HashMap<String, AbstractCommonConfig> map = new HashMap<String, AbstractCommonConfig>(this.configs.size(), 1.0f);
        if (this.wrapper != null) {
            for (Map.Entry<String, T> e : this.configs.entrySet()) {
                map.put(e.getKey(), this.newInstance((AbstractCommonConfig)e.getValue(), this.wrapper));
            }
        } else {
            for (Map.Entry<String, T> e : this.configs.entrySet()) {
                map.put(e.getKey(), (AbstractCommonConfig)e.getValue());
            }
        }
        this.loadedConfigs = Collections.unmodifiableMap(map);
    }

    public synchronized void unload() {
        this.loadedConfigs = Collections.emptyMap();
    }

    public synchronized void setWrapperConfig(T config, boolean reload) {
        this.wrapper = config;
        if (reload) {
            this.reload();
        }
    }

    public synchronized T getWrapperConfig() {
        return this.wrapper;
    }

    public T getConfig(String name) {
        return (T)((AbstractCommonConfig)this.loadedConfigs.get(name));
    }

    public Collection<T> getConfigs() {
        return this.loadedConfigs.values();
    }
}

