/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.jgroups.Address;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpConnection;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class TcpConnectionNonBlocking
extends TcpConnection {
    protected BlockingQueue<ByteArray> queue;
    protected int max_size = 128;
    protected volatile Sender sender;
    protected final LongAdder dropped_msgs = new LongAdder();

    public TcpConnectionNonBlocking(Address peer_addr, TcpBaseServer server) throws Exception {
        super(peer_addr, server);
    }

    public TcpConnectionNonBlocking(Socket s, TcpServer server) throws Exception {
        super(s, server);
    }

    public int maxSize() {
        return this.max_size;
    }

    public TcpConnectionNonBlocking maxSize(int s) {
        this.max_size = s;
        return this;
    }

    public long droppedMessages() {
        return this.dropped_msgs.sum();
    }

    public int queueSize() {
        return this.queue != null ? this.queue.size() : 0;
    }

    @Override
    public void start() {
        super.start();
        this.queue = new ArrayBlockingQueue<ByteArray>(this.max_size);
        if (this.sender != null) {
            this.sender.stop();
        }
        this.sender = new Sender(this.server.factory).start();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.sender != null) {
            this.sender.stop();
            this.sender = null;
        }
    }

    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        ByteArray buf = new ByteArray(data, offset, length).copy();
        boolean added = this.queue.offer(buf);
        if (!added) {
            this.dropped_msgs.increment();
        }
    }

    @Override
    public String toString() {
        return String.format("%s [%d/%d, %d drops, sender: %b]", super.toString(), this.queueSize(), this.maxSize(), this.droppedMessages(), this.senderRunning());
    }

    protected String name() {
        InetAddress local = this.sock.getLocalAddress();
        InetAddress remote = this.sock.getInetAddress();
        String l = local != null ? Util.shortName(local) : "<null>";
        String r = remote != null ? Util.shortName(remote) : "<null>";
        return String.format("Connection.Sender [%s:%s-%s:%s]", l, this.sock.getLocalPort(), r, this.sock.getPort());
    }

    protected boolean senderRunning() {
        Sender tmp = this.sender;
        return tmp != null && tmp.running();
    }

    protected class Sender
    implements Runnable {
        protected final Thread thread;
        protected volatile boolean running = true;

        public Sender(ThreadFactory f) {
            String name = TcpConnectionNonBlocking.this.name();
            this.thread = f != null ? f.newThread(this, name) : new Thread((Runnable)this, name);
        }

        public Sender start() {
            this.running = true;
            this.thread.start();
            return this;
        }

        public Sender stop() {
            this.running = false;
            Thread t = this.thread;
            if (t != null && t.isAlive()) {
                t.interrupt();
            }
            return this;
        }

        public boolean running() {
            return this.running && TcpConnectionNonBlocking.this.isConnected();
        }

        @Override
        public void run() {
            try {
                while (this.running()) {
                    ByteArray data;
                    try {
                        data = TcpConnectionNonBlocking.this.queue.take();
                    }
                    catch (InterruptedException iex) {
                        continue;
                    }
                    TcpConnectionNonBlocking.this.doSend(data.getArray(), data.getOffset(), data.getLength(), true);
                }
            }
            catch (EOFException | SocketException data) {
            }
            catch (Exception e) {
                if (e instanceof SSLException && e.getMessage().contains("Socket closed")) {
                } else if (e instanceof SSLHandshakeException && e.getCause() instanceof EOFException) {
                } else if (TcpConnectionNonBlocking.this.server.logDetails()) {
                    TcpConnectionNonBlocking.this.server.log.warn("failed sending message", e);
                } else {
                    TcpConnectionNonBlocking.this.server.log.warn("failed sending message: " + String.valueOf(e));
                }
            }
            finally {
                TcpConnectionNonBlocking.this.server.notifyConnectionClosed(TcpConnectionNonBlocking.this);
            }
        }
    }
}

