/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AccumulatingSourceExtractor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;

public class ElasticsearchObjectProjection<E, V, P>
extends AbstractElasticsearchProjection<P> {
    private final String absoluteFieldPath;
    private final String[] absoluteFieldPathComponents;
    private final String requiredContextAbsoluteFieldPath;
    private final ElasticsearchSearchProjection<?>[] inners;
    private final ProjectionCompositor<E, V> compositor;
    private final ProjectionAccumulator.Provider<V, P> accumulatorProvider;

    public ElasticsearchObjectProjection(Builder builder, ElasticsearchSearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
        super(builder.scope);
        this.absoluteFieldPath = builder.objectField.absolutePath();
        this.absoluteFieldPathComponents = builder.objectField.absolutePathComponents();
        this.requiredContextAbsoluteFieldPath = accumulatorProvider.isSingleValued() ? builder.objectField.closestMultiValuedParentAbsolutePath() : null;
        this.inners = inners;
        this.compositor = compositor;
        this.accumulatorProvider = accumulatorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + this.compositor + ", accumulatorProvider=" + this.accumulatorProvider + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        ProjectionRequestContext innerContext = context.forField(this.absoluteFieldPath, this.absoluteFieldPathComponents);
        if (this.requiredContextAbsoluteFieldPath != null && !this.requiredContextAbsoluteFieldPath.equals(context.absoluteCurrentFieldPath())) {
            throw log.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        String[] extractorFieldPathComponents = innerContext.relativeCurrentFieldPathComponents();
        JsonPrimitive fieldPathJson = new JsonPrimitive(this.absoluteFieldPath);
        AccumulatingSourceExtractor.REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)fieldPathJson);
        ElasticsearchSearchProjection.Extractor[] innerExtractors = new ElasticsearchSearchProjection.Extractor[this.inners.length];
        for (int i = 0; i < this.inners.length; ++i) {
            innerExtractors[i] = this.inners[i].request(requestBody, innerContext);
        }
        return new ObjectFieldExtractor(extractorFieldPathComponents, this.accumulatorProvider.get(), innerExtractors);
    }

    static class Builder
    implements CompositeProjectionBuilder {
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexCompositeNodeContext objectField;

        Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext objectField) {
            this.scope = scope;
            this.objectField = objectField;
        }

        public <E, V, P> SearchProjection<P> build(SearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.objectField.multiValued()) {
                throw ElasticsearchSearchProjection.log.invalidSingleValuedProjectionOnMultiValuedField(this.objectField.absolutePath(), this.objectField.eventContext());
            }
            ElasticsearchSearchProjection[] typedInners = new ElasticsearchSearchProjection[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                typedInners[i] = ElasticsearchSearchProjection.from(this.scope, inners[i]);
            }
            return new ElasticsearchObjectProjection<E, V, P>(this, typedInners, compositor, accumulatorProvider);
        }
    }

    private class ObjectFieldExtractor<A>
    extends AccumulatingSourceExtractor<E, V, A, P> {
        private final ElasticsearchSearchProjection.Extractor<?, ?>[] inners;

        private ObjectFieldExtractor(String[] fieldPathComponents, ProjectionAccumulator<E, V, A, P> accumulator, ElasticsearchSearchProjection.Extractor<?, ?>[] inners) {
            super(fieldPathComponents, accumulator);
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + ElasticsearchObjectProjection.this.compositor + ", accumulator=" + this.accumulator + "]";
        }

        @Override
        protected E extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonElement sourceElement, ProjectionExtractContext context) {
            if (sourceElement == null || sourceElement.isJsonNull()) {
                return null;
            }
            JsonObject sourceObject = sourceElement.getAsJsonObject();
            Object components = ElasticsearchObjectProjection.this.compositor.createInitial();
            for (int i = 0; i < this.inners.length; ++i) {
                Object extractedDataForInner = this.inners[i].extract(projectionHitMapper, hit, sourceObject, context);
                components = ElasticsearchObjectProjection.this.compositor.set(components, i, extractedDataForInner);
            }
            return components;
        }

        @Override
        protected boolean canDecodeArrays() {
            return false;
        }

        @Override
        public final P transform(LoadingResult<?> loadingResult, A accumulated, ProjectionTransformContext context) {
            for (int i = 0; i < this.accumulator.size(accumulated); ++i) {
                Object transformedData = this.accumulator.get(accumulated, i);
                if (transformedData == null) continue;
                for (int j = 0; j < this.inners.length; ++j) {
                    Object extractedDataForInner = ElasticsearchObjectProjection.this.compositor.get(transformedData, j);
                    Object transformedDataForInner = ElasticsearchSearchProjection.Extractor.transformUnsafe(this.inners[j], loadingResult, extractedDataForInner, context);
                    transformedData = ElasticsearchObjectProjection.this.compositor.set(transformedData, j, transformedDataForInner);
                }
                accumulated = this.accumulator.transform(accumulated, i, ElasticsearchObjectProjection.this.compositor.finish(transformedData));
            }
            return this.accumulator.finish(accumulated);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<Builder> {
        public Builder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext objectField) {
            return new Builder(scope, objectField);
        }
    }
}

