/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.Map;
import org.wildfly.common.Assert;

public class AddressClaimSet {
    public static final String FORMATTED = "formatted";
    public static final String STREET_ADDRESS = "street_address";
    public static final String LOCALITY = "locality";
    public static final String REGION = "region";
    public static final String POSTAL_CODE = "postal_code";
    public static final String COUNTRY = "country";
    private final Map<String, String> addressClaimSet;

    public AddressClaimSet(Map<String, String> addressClaimSet) {
        Assert.checkNotNullParam((String)"addressClaimSet", addressClaimSet);
        this.addressClaimSet = addressClaimSet;
    }

    public String getFormattedAddress() {
        return this.addressClaimSet.get(FORMATTED);
    }

    public String getStreetAddress() {
        return this.addressClaimSet.get(STREET_ADDRESS);
    }

    public String getLocality() {
        return this.addressClaimSet.get(LOCALITY);
    }

    public String getRegion() {
        return this.addressClaimSet.get(REGION);
    }

    public String getPostalCode() {
        return this.addressClaimSet.get(POSTAL_CODE);
    }

    public String getCountry() {
        return this.addressClaimSet.get(COUNTRY);
    }
}

