/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.infinispan;

import java.util.function.Function;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationBuilder;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.externalizer.LegacyExternalizerConfiguratorFactory;
import org.wildfly.clustering.server.deployment.DeploymentConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.service.session.LegacyDistributableSessionManagementProviderFactory;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.web.routing.LocalRouteLocatorProvider;
import org.wildfly.extension.clustering.web.routing.infinispan.PrimaryOwnerRouteLocatorProvider;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;

@Deprecated
public class InfinispanLegacySessionManagementProviderFactory
implements LegacyDistributableSessionManagementProviderFactory,
Function<DeploymentUnit, ByteBufferMarshaller> {
    public DistributableSessionManagementProvider createSessionManagerProvider(final DeploymentUnit unit, final ReplicationConfig config) {
        String replicationConfigCacheName = config != null ? config.getCacheName() : null;
        ServiceName replicationConfigServiceName = ServiceNameFactory.parseServiceName((String)(replicationConfigCacheName != null ? replicationConfigCacheName : "web"));
        ServiceName baseReplicationConfigServiceName = ServiceName.JBOSS.append(new String[]{"infinispan"});
        if (!baseReplicationConfigServiceName.isParentOf(replicationConfigServiceName)) {
            replicationConfigServiceName = baseReplicationConfigServiceName.append(replicationConfigServiceName);
        }
        String containerName = (replicationConfigServiceName.length() > 3 ? replicationConfigServiceName.getParent() : replicationConfigServiceName).getSimpleName();
        String cacheName = replicationConfigServiceName.length() > 3 ? replicationConfigServiceName.getSimpleName() : null;
        DistributableSessionManagementConfiguration<DeploymentUnit> configuration = new DistributableSessionManagementConfiguration<DeploymentUnit>(){

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                ReplicationGranularity granularity = config != null ? config.getReplicationGranularity() : null;
                return granularity == ReplicationGranularity.ATTRIBUTE ? SessionAttributePersistenceStrategy.FINE : SessionAttributePersistenceStrategy.COARSE;
            }

            public Function<DeploymentUnit, ByteBufferMarshaller> getMarshallerFactory() {
                return InfinispanLegacySessionManagementProviderFactory.this;
            }
        };
        return new InfinispanSessionManagementProvider(configuration, BinaryServiceConfiguration.of((String)containerName, (String)cacheName), Functions.constantSupplier((Object)new RouteLocatorProvider(){

            public DeploymentServiceInstaller getServiceInstaller(DeploymentPhaseContext context, BinaryServiceConfiguration infinispan, DeploymentConfiguration deployment) {
                CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                boolean forceLocalRouting = support.hasCapability(RoutingProvider.SERVICE_DESCRIPTOR) && !support.hasCapability(RoutingProvider.INFINISPAN_SERVICE_DESCRIPTOR);
                LocalRouteLocatorProvider provider = forceLocalRouting ? new LocalRouteLocatorProvider() : new PrimaryOwnerRouteLocatorProvider();
                return provider.getServiceInstaller(context, infinispan, deployment);
            }
        }));
    }

    @Override
    public ByteBufferMarshaller apply(DeploymentUnit unit) {
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        return new JBossByteBufferMarshaller(MarshallingConfigurationRepository.from((Enum)JBossMarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
    }

    private static enum JBossMarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                return (MarshallingConfiguration)MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader())).build();
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfigurationBuilder builder = MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                return (MarshallingConfiguration)new LegacyExternalizerConfiguratorFactory((ClassLoader)module.getClassLoader()).apply(builder).build();
            }
        };

        static final JBossMarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

