/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.session.infinispan;

import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheServiceInstallerFactory;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceInstallerFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.web.service.WebDeploymentServiceDescriptor;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.web.session.AbstractSessionManagementProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanSessionManagementProvider
extends AbstractSessionManagementProvider {
    public InfinispanSessionManagementProvider(DistributableSessionManagementConfiguration<DeploymentUnit> configuration, BinaryServiceConfiguration cacheConfiguration, Supplier<RouteLocatorProvider> locatorProviderFactory) {
        super(configuration, cacheConfiguration, locatorProviderFactory);
    }

    public <C> DeploymentServiceInstaller getSessionManagerFactoryServiceInstaller(final SessionManagerFactoryConfiguration<C> configuration) {
        BinaryServiceConfiguration deploymentCacheConfiguration = this.getCacheConfiguration().withChildName(configuration.getDeploymentName());
        Consumer<ConfigurationBuilder> configurator = new Consumer<ConfigurationBuilder>(){

            @Override
            public void accept(ConfigurationBuilder builder) {
                OptionalInt size;
                ExpirationConfiguration expiration = builder.expiration().create();
                if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                    builder.expiration().lifespan(-1L).maxIdle(-1L);
                }
                EvictionStrategy strategy = (size = configuration.getMaxActiveSessions()).isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
                builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount((long)size.orElse(0));
                if (strategy.isEnabled()) {
                    ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
                }
                PersistenceConfiguration persistence = builder.persistence().create();
                if (size.isEmpty() && persistence.passivation() && persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
                    builder.persistence().passivation(false).clearStores();
                }
            }
        };
        ServiceInstaller configurationInstaller = new TemplateConfigurationServiceInstallerFactory((Consumer)configurator).apply(this.getCacheConfiguration(), deploymentCacheConfiguration);
        ServiceInstaller cacheInstaller = CacheServiceInstallerFactory.INSTANCE.apply(deploymentCacheConfiguration);
        final ServiceDependency commandDispatcherFactory = deploymentCacheConfiguration.getServiceDependency(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).map(CacheContainerCommandDispatcherFactory.class::cast);
        final ServiceDependency cache = deploymentCacheConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final InfinispanSessionManagerFactoryConfiguration factoryConfiguration = new InfinispanSessionManagerFactoryConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return (CacheContainerCommandDispatcherFactory)commandDispatcherFactory.get();
            }
        };
        Supplier factory = new Supplier<SessionManagerFactory<ServletContext, C>>(){

            @Override
            public SessionManagerFactory<ServletContext, C> get() {
                return new InfinispanSessionManagerFactory(configuration, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, factoryConfiguration);
            }
        };
        DeploymentServiceInstaller installer = (DeploymentServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)WebDeploymentServiceDescriptor.SESSION_MANAGER_FACTORY, (String)configuration.getDeploymentName()))).requires(List.of(cache, commandDispatcherFactory))).onStop(Functions.closingConsumer())).build();
        return DeploymentServiceInstaller.combine((DeploymentServiceInstaller[])new DeploymentServiceInstaller[]{configurationInstaller, cacheInstaller, installer});
    }
}

