/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import jakarta.annotation.Priority;
import jakarta.json.bind.Jsonb;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider;
import org.jboss.resteasy.plugins.providers.jsonb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jsonb.i18n.Messages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.util.DelegatingOutputStream;

@Provider
@Produces(value={"application/json", "application/*+json", "text/json"})
@Consumes(value={"application/json", "application/*+json", "text/json"})
@Priority(value=4900)
public class JsonBindingProvider
extends AbstractJsonBindingProvider
implements MessageBodyReader<Object>,
AsyncMessageBodyWriter<Object> {
    private final boolean disabled;

    public JsonBindingProvider() {
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyContext.getContextData(ResteasyConfiguration.class);
        this.disabled = context == null ? Boolean.getBoolean("resteasy.preferJacksonOverJsonB") : Boolean.parseBoolean(context.getParameter("resteasy.preferJacksonOverJsonB")) || Boolean.parseBoolean(context.getParameter("resteasy.jsonp.enable"));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object object;
        block9: {
            EmptyCheckInputStream is = new EmptyCheckInputStream(entityStream);
            Jsonb jsonb = this.getJsonb(type);
            try {
                object = jsonb.fromJson((InputStream)is, genericType);
                if (jsonb == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (is.isEmpty()) {
                        return null;
                    }
                    throw new ProcessingException(Messages.MESSAGES.jsonBDeserializationError(e.toString()), e);
                }
            }
            jsonb.close();
        }
        return object;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (Jsonb jsonb = this.getJsonb(type);){
            entityStream = new DelegatingOutputStream((OutputStream)entityStream){

                public void flush() throws IOException {
                }
            };
            ((OutputStream)entityStream).write(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType)));
            ((OutputStream)entityStream).flush();
        }
        catch (Throwable e) {
            throw new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()), e);
        }
    }

    public CompletionStage<Void> asyncWriteTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        Jsonb jsonb = this.getJsonb(type);
        try {
            return entityStream.asyncWrite(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType))).whenComplete((unused, throwable) -> {
                try {
                    jsonb.close();
                }
                catch (Exception e) {
                    LogMessages.LOGGER.debug("Failed to close the JSONB context.", e);
                }
            });
        }
        catch (Throwable e) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally((Throwable)new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()), e));
            try {
                jsonb.close();
            }
            catch (Exception ex) {
                LogMessages.LOGGER.debug("Failed to close the JSONB context.", ex);
            }
            return ret;
        }
    }

    private static class EmptyCheckInputStream
    extends InputStream {
        private final InputStream delegate;
        boolean read = false;
        boolean empty = false;

        EmptyCheckInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            int i = this.delegate.read();
            this.afterRead(i);
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int i = this.delegate.read();
            this.afterRead(i);
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i = this.delegate.read(b, off, len);
            this.afterRead(i);
            return i;
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }

        private synchronized void afterRead(int n) {
            if (!this.read && n <= 0) {
                this.empty = true;
            }
            this.read = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

