/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.AddressSettingsValidator;
import org.wildfly.extension.messaging.activemq.CommonAttributes;

class AddressSettingAdd
extends AbstractAddStepHandler {
    static final OperationStepHandler INSTANCE = new AddressSettingAdd(AddressSettingDefinition.ATTRIBUTES);

    private AddressSettingAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        context.addStep(AddressSettingsValidator.ADD_VALIDATOR, OperationContext.Stage.MODEL, false);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime() && !context.isBooting();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ActiveMQServer server = ActiveMQActivationService.getActiveMQServer(context, operation);
        if (server != null) {
            boolean isRootAddressMatch = server.getConfiguration().getWildcardConfiguration().getAnyWordsString().equals(context.getCurrentAddressValue());
            AddressSettings settings = AddressSettingAdd.createSettings(context, model, isRootAddressMatch);
            if (isRootAddressMatch) {
                settings.merge(AddressSettingAdd.createDefaulAddressSettings());
            }
            server.getAddressSettingsRepository().addMatch(context.getCurrentAddressValue(), (Object)settings);
        }
    }

    static AddressSettings createDefaulAddressSettings() {
        AddressSettings settings = new AddressSettings();
        settings.setAddressFullMessagePolicy(AddressFullMessagePolicy.valueOf((String)AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.getDefaultValue().asString()));
        settings.setAutoCreateJmsQueues(AddressSettingDefinition.AUTO_CREATE_JMS_QUEUES.getDefaultValue().asBoolean());
        settings.setAutoDeleteJmsQueues(AddressSettingDefinition.AUTO_DELETE_JMS_QUEUES.getDefaultValue().asBoolean());
        settings.setAutoCreateQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_QUEUES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_QUEUES.getDefaultValue().asBoolean()));
        settings.setAutoCreateAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_ADDRESSES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_ADDRESSES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteCreatedQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES.getDefaultValue().asBoolean()));
        settings.setMaxReadPageBytes(AddressSettingDefinition.MAX_READ_PAGE_BYTES.getDefaultValue().asInt());
        settings.setDeadLetterAddress(AddressSettingAdd.asSimpleString(CommonAttributes.DEAD_LETTER_ADDRESS.getDefaultValue(), null));
        settings.setExpiryAddress(AddressSettingAdd.asSimpleString(CommonAttributes.EXPIRY_ADDRESS.getDefaultValue(), null));
        settings.setExpiryDelay(Long.valueOf(AddressSettingDefinition.EXPIRY_DELAY.getDefaultValue().asLong()));
        settings.setDefaultLastValueQueue(AddressSettingDefinition.LAST_VALUE_QUEUE.getDefaultValue().asBoolean());
        settings.setMaxDeliveryAttempts(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.getDefaultValue().asInt());
        settings.setMaxRedeliveryDelay(AddressSettingDefinition.MAX_REDELIVERY_DELAY.getDefaultValue().asLong());
        settings.setMaxSizeBytes(AddressSettingDefinition.MAX_SIZE_BYTES.getDefaultValue().asLong());
        settings.setMessageCounterHistoryDayLimit(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.getDefaultValue().asInt());
        settings.setPageCacheMaxSize(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.getDefaultValue().asInt());
        settings.setPageSizeBytes(AddressSettingDefinition.PAGE_SIZE_BYTES.getDefaultValue().asInt());
        settings.setRedeliveryDelay(AddressSettingDefinition.REDELIVERY_DELAY.getDefaultValue().asLong());
        settings.setRedeliveryMultiplier(AddressSettingDefinition.REDELIVERY_MULTIPLIER.getDefaultValue().asDouble());
        settings.setRedistributionDelay(AddressSettingDefinition.REDISTRIBUTION_DELAY.getDefaultValue().asLong());
        settings.setSendToDLAOnNoRoute(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.getDefaultValue().asBoolean());
        settings.setSlowConsumerCheckPeriod(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.getDefaultValue().asLong());
        settings.setSlowConsumerPolicy(SlowConsumerPolicy.valueOf((String)AddressSettingDefinition.SLOW_CONSUMER_POLICY.getDefaultValue().asString()));
        settings.setSlowConsumerThreshold(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.getDefaultValue().asLong());
        return settings;
    }

    static AddressSettings createSettings(OperationContext context, ModelNode config, boolean isRootAddressMatch) throws OperationFailedException {
        AddressSettings settings = new AddressSettings();
        if (config.hasDefined(AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.getName())) {
            AddressFullMessagePolicy addressPolicy = AddressFullMessagePolicy.valueOf((String)AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.resolveModelAttribute(context, config).asString());
            settings.setAddressFullMessagePolicy(addressPolicy);
        }
        settings.setAutoCreateJmsQueues(AddressSettingDefinition.AUTO_CREATE_JMS_QUEUES.resolveModelAttribute(context, config).asBoolean());
        settings.setAutoDeleteJmsQueues(AddressSettingDefinition.AUTO_DELETE_JMS_QUEUES.resolveModelAttribute(context, config).asBoolean());
        settings.setAutoCreateQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_QUEUES.resolveModelAttribute(context, config).asBoolean()));
        settings.setAutoDeleteQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_QUEUES.resolveModelAttribute(context, config).asBoolean()));
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.AUTO_CREATE_ADDRESSES.getName())) {
            settings.setAutoCreateAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_ADDRESSES.resolveModelAttribute(context, config).asBoolean()));
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.AUTO_DELETE_ADDRESSES.getName())) {
            settings.setAutoDeleteAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_ADDRESSES.resolveModelAttribute(context, config).asBoolean()));
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES.getName())) {
            settings.setAutoDeleteCreatedQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES.resolveModelAttribute(context, config).asBoolean()));
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.MAX_READ_PAGE_BYTES.getName())) {
            settings.setMaxReadPageBytes(AddressSettingDefinition.MAX_READ_PAGE_BYTES.resolveModelAttribute(context, config).asInt());
        }
        if (isRootAddressMatch || config.hasDefined(CommonAttributes.DEAD_LETTER_ADDRESS.getName())) {
            settings.setDeadLetterAddress(AddressSettingAdd.asSimpleString(CommonAttributes.DEAD_LETTER_ADDRESS.resolveModelAttribute(context, config), null));
        }
        if (isRootAddressMatch || config.hasDefined(CommonAttributes.EXPIRY_ADDRESS.getName())) {
            settings.setExpiryAddress(AddressSettingAdd.asSimpleString(CommonAttributes.EXPIRY_ADDRESS.resolveModelAttribute(context, config), null));
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.EXPIRY_DELAY.getName())) {
            settings.setExpiryDelay(Long.valueOf(AddressSettingDefinition.EXPIRY_DELAY.resolveModelAttribute(context, config).asLong()));
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.LAST_VALUE_QUEUE.getName())) {
            settings.setDefaultLastValueQueue(AddressSettingDefinition.LAST_VALUE_QUEUE.resolveModelAttribute(context, config).asBoolean());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.getName())) {
            settings.setMaxDeliveryAttempts(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.resolveModelAttribute(context, config).asInt());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.MAX_REDELIVERY_DELAY.getName())) {
            settings.setMaxRedeliveryDelay(AddressSettingDefinition.MAX_REDELIVERY_DELAY.resolveModelAttribute(context, config).asLong());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.MAX_SIZE_BYTES.getName())) {
            settings.setMaxSizeBytes(AddressSettingDefinition.MAX_SIZE_BYTES.resolveModelAttribute(context, config).asLong());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.getName())) {
            settings.setMessageCounterHistoryDayLimit(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.resolveModelAttribute(context, config).asInt());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.getName())) {
            settings.setPageCacheMaxSize(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.resolveModelAttribute(context, config).asInt());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.PAGE_SIZE_BYTES.getName())) {
            settings.setPageSizeBytes(AddressSettingDefinition.PAGE_SIZE_BYTES.resolveModelAttribute(context, config).asInt());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.REDELIVERY_DELAY.getName())) {
            settings.setRedeliveryDelay(AddressSettingDefinition.REDELIVERY_DELAY.resolveModelAttribute(context, config).asLong());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.REDELIVERY_MULTIPLIER.getName())) {
            settings.setRedeliveryMultiplier(AddressSettingDefinition.REDELIVERY_MULTIPLIER.resolveModelAttribute(context, config).asDouble());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.REDISTRIBUTION_DELAY.getName())) {
            settings.setRedistributionDelay(AddressSettingDefinition.REDISTRIBUTION_DELAY.resolveModelAttribute(context, config).asLong());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.getName())) {
            settings.setSendToDLAOnNoRoute(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.resolveModelAttribute(context, config).asBoolean());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.getName())) {
            settings.setSlowConsumerCheckPeriod(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.resolveModelAttribute(context, config).asLong());
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_POLICY.getName())) {
            SlowConsumerPolicy slowConsumerPolicy = SlowConsumerPolicy.valueOf((String)AddressSettingDefinition.SLOW_CONSUMER_POLICY.resolveModelAttribute(context, config).asString());
            settings.setSlowConsumerPolicy(slowConsumerPolicy);
        }
        if (isRootAddressMatch || config.hasDefined(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.getName())) {
            settings.setSlowConsumerThreshold(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.resolveModelAttribute(context, config).asLong());
        }
        return settings;
    }

    static AddressSettings createDefaultAddressSettings() {
        AddressSettings settings = new AddressSettings();
        settings.setAddressFullMessagePolicy(AddressFullMessagePolicy.valueOf((String)AddressSettingDefinition.ADDRESS_FULL_MESSAGE_POLICY.getDefaultValue().asString()));
        settings.setAutoCreateJmsQueues(AddressSettingDefinition.AUTO_CREATE_JMS_QUEUES.getDefaultValue().asBoolean());
        settings.setAutoDeleteJmsQueues(AddressSettingDefinition.AUTO_DELETE_JMS_QUEUES.getDefaultValue().asBoolean());
        settings.setAutoCreateQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_QUEUES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_QUEUES.getDefaultValue().asBoolean()));
        settings.setAutoCreateAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_CREATE_ADDRESSES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteAddresses(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_ADDRESSES.getDefaultValue().asBoolean()));
        settings.setAutoDeleteCreatedQueues(Boolean.valueOf(AddressSettingDefinition.AUTO_DELETE_CREATED_QUEUES.getDefaultValue().asBoolean()));
        settings.setMaxReadPageBytes(AddressSettingDefinition.MAX_READ_PAGE_BYTES.getDefaultValue().asInt());
        settings.setDeadLetterAddress(AddressSettingAdd.asSimpleString(CommonAttributes.DEAD_LETTER_ADDRESS.getDefaultValue(), null));
        settings.setExpiryAddress(AddressSettingAdd.asSimpleString(CommonAttributes.EXPIRY_ADDRESS.getDefaultValue(), null));
        settings.setExpiryDelay(Long.valueOf(AddressSettingDefinition.EXPIRY_DELAY.getDefaultValue().asLong()));
        settings.setDefaultLastValueQueue(AddressSettingDefinition.LAST_VALUE_QUEUE.getDefaultValue().asBoolean());
        settings.setMaxDeliveryAttempts(AddressSettingDefinition.MAX_DELIVERY_ATTEMPTS.getDefaultValue().asInt());
        settings.setMaxRedeliveryDelay(AddressSettingDefinition.MAX_REDELIVERY_DELAY.getDefaultValue().asLong());
        settings.setMaxSizeBytes(AddressSettingDefinition.MAX_SIZE_BYTES.getDefaultValue().asLong());
        settings.setMessageCounterHistoryDayLimit(AddressSettingDefinition.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.getDefaultValue().asInt());
        settings.setPageCacheMaxSize(AddressSettingDefinition.PAGE_MAX_CACHE_SIZE.getDefaultValue().asInt());
        settings.setPageSizeBytes(AddressSettingDefinition.PAGE_SIZE_BYTES.getDefaultValue().asInt());
        settings.setRedeliveryDelay(AddressSettingDefinition.REDELIVERY_DELAY.getDefaultValue().asLong());
        settings.setRedeliveryMultiplier(AddressSettingDefinition.REDELIVERY_MULTIPLIER.getDefaultValue().asDouble());
        settings.setRedistributionDelay(AddressSettingDefinition.REDISTRIBUTION_DELAY.getDefaultValue().asLong());
        settings.setSendToDLAOnNoRoute(AddressSettingDefinition.SEND_TO_DLA_ON_NO_ROUTE.getDefaultValue().asBoolean());
        settings.setSlowConsumerCheckPeriod(AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD.getDefaultValue().asLong());
        settings.setSlowConsumerPolicy(SlowConsumerPolicy.valueOf((String)AddressSettingDefinition.SLOW_CONSUMER_POLICY.getDefaultValue().asString()));
        settings.setSlowConsumerThreshold(AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD.getDefaultValue().asLong());
        return settings;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node != null && node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }
}

