/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;

public final class LuceneStringFieldCodec
implements LuceneFieldCodec<String, String> {
    private final FieldType mainFieldType;
    private final DocValues docValues;
    private final String indexNullAsValue;
    private final Analyzer analyzerOrNormalizer;

    public LuceneStringFieldCodec(FieldType mainFieldType, DocValues docValues, String indexNullAsValue, Analyzer analyzerOrNormalizer) {
        this.mainFieldType = mainFieldType;
        this.docValues = docValues;
        this.indexNullAsValue = indexNullAsValue;
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    @Override
    public void addToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, String value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        if (this.mainFieldType != null) {
            documentBuilder.addField((IndexableField)new Field(absoluteFieldPath, (CharSequence)value, (IndexableFieldType)this.mainFieldType));
        }
        if (DocValues.ENABLED.equals((Object)this.docValues)) {
            BytesRef normalized = this.normalize(absoluteFieldPath, value);
            documentBuilder.addField((IndexableField)new SortedSetDocValuesField(absoluteFieldPath, normalized));
        }
        if ((this.mainFieldType == null || this.mainFieldType.omitNorms()) && DocValues.DISABLED.equals((Object)this.docValues)) {
            documentBuilder.addFieldName(absoluteFieldPath);
        }
    }

    @Override
    public String decode(IndexableField field) {
        return field.stringValue();
    }

    @Override
    public String raw(IndexableField field) {
        return this.decode(field);
    }

    @Override
    public String decode(String field) {
        return field;
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?, ?> obj) {
        if (this == obj) {
            return true;
        }
        return LuceneStringFieldCodec.class == obj.getClass();
    }

    @Override
    public String encode(String value) {
        return value;
    }

    private BytesRef normalize(String absoluteFieldPath, String value) {
        if (value == null) {
            return null;
        }
        if (this.analyzerOrNormalizer == AnalyzerConstants.KEYWORD_ANALYZER) {
            return new BytesRef((CharSequence)value);
        }
        return this.analyzerOrNormalizer.normalize(absoluteFieldPath, value);
    }

    @Override
    public Class<String> encodedType() {
        return String.class;
    }
}

