/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ConstructorMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingIndexedStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingSearchEntityStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.InitialConstructorMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.InitialPropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeBridgeMappingContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingIndexedStepImpl;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingSearchEntityStepImpl;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public class TypeMappingStepImpl
implements TypeMappingStep,
PojoMappingConfigurationContributor,
PojoTypeMetadataContributor {
    private final PojoRawTypeModel<?> typeModel;
    private final ErrorCollectingPojoTypeMetadataContributor children = new ErrorCollectingPojoTypeMetadataContributor();
    private Map<List<Class<?>>, InitialConstructorMappingStep> constructors;

    public TypeMappingStepImpl(PojoRawTypeModel<?> typeModel) {
        this.typeModel = typeModel;
    }

    @Override
    public void configure(MappingBuildContext buildContext, PojoMappingConfigurationContext configurationContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        configurationCollector.collectContributor(this.typeModel, (Object)this);
    }

    @Override
    public void contributeAdditionalMetadata(PojoAdditionalMetadataCollectorTypeNode collector) {
        this.children.contributeAdditionalMetadata(collector);
    }

    @Override
    public void contributeIndexMapping(PojoIndexMappingCollectorTypeNode collector) {
        this.children.contributeIndexMapping(collector);
    }

    @Override
    public TypeMappingIndexedStep indexed() {
        TypeMappingIndexedStepImpl child = new TypeMappingIndexedStepImpl(this.typeModel.typeIdentifier());
        this.children.add(child);
        return child;
    }

    @Override
    public TypeMappingSearchEntityStep searchEntity() {
        TypeMappingSearchEntityStepImpl child = new TypeMappingSearchEntityStepImpl(this.typeModel.typeIdentifier());
        this.children.add(child);
        return child;
    }

    @Override
    public TypeMappingStep binder(TypeBinder binder, Map<String, Object> params) {
        this.children.add(new TypeBridgeMappingContributor(binder, params));
        return this;
    }

    @Override
    public ConstructorMappingStep mainConstructor() {
        return this.constructor(this.typeModel.mainConstructor().parametersJavaTypes());
    }

    @Override
    public ConstructorMappingStep constructor(Class<?> ... parameterTypes) {
        List<Class<?>> key;
        InitialConstructorMappingStep result;
        if (this.constructors == null) {
            this.constructors = new LinkedHashMap();
        }
        if ((result = this.constructors.get(key = Arrays.asList(parameterTypes))) == null) {
            result = new InitialConstructorMappingStep(this, this.typeModel.constructor(parameterTypes));
            this.constructors.put(key, result);
        }
        return result;
    }

    @Override
    public Map<List<Class<?>>, ? extends PojoSearchMappingConstructorNode> constructors() {
        return this.constructors == null ? Collections.emptyMap() : this.constructors;
    }

    @Override
    public PropertyMappingStep property(String propertyName) {
        PojoPropertyModel<?> propertyModel = this.typeModel.property(propertyName);
        InitialPropertyMappingStep child = new InitialPropertyMappingStep(this, propertyModel);
        this.children.add(child);
        return child;
    }

    PojoRawTypeModel<?> getTypeModel() {
        return this.typeModel;
    }
}

