/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.instmgr.InstMgrCustomPatchHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrCustomPatchRemoveHandler
extends InstMgrCustomPatchHandler {
    public static final String OPERATION_NAME = "remove-custom-patch";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-custom-patch", InstMgrResolver.getResourceDescriptionResolver("custom-patch")).addParameter(MANIFEST_GA).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setRuntimeOnly().build();

    public InstMgrCustomPatchRemoveHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String manifestGA = MANIFEST_GA.resolveModelAttribute(context, operation).asString();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.acquireControllerLock();
                try {
                    String translatedManifestGA = manifestGA.replace(":", "_");
                    Path serverHome = InstMgrCustomPatchRemoveHandler.this.imService.getHomeDir();
                    Path baseTargetDir = InstMgrCustomPatchRemoveHandler.this.imService.getCustomPatchDir(translatedManifestGA);
                    MavenOptions mavenOptions = new MavenOptions(null, false);
                    InstallationManager im = InstMgrCustomPatchRemoveHandler.this.imf.create(serverHome, mavenOptions);
                    boolean existTargetDir = Files.exists(baseTargetDir, new LinkOption[0]);
                    InstMgrCustomPatchRemoveHandler.this.deleteDirIfExits(baseTargetDir);
                    Collection exitingChannels = im.listChannels();
                    boolean channelFound = false;
                    for (Channel channel : exitingChannels) {
                        String name = channel.getName();
                        if (!channel.getName().equals("custom-channel-" + translatedManifestGA)) continue;
                        channelFound = true;
                        im.removeChannel(name);
                        break;
                    }
                    if (!existTargetDir && !channelFound) {
                        throw InstMgrLogger.ROOT_LOGGER.noCustomPatchFound(manifestGA);
                    }
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

