/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;

class RealmDefinitions {
    static final AttributeDefinition IDENTITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("identity", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final AttributeDefinition ATTRIBUTE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute-name", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final StringListAttributeDefinition ATTRIBUTE_VALUES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("attribute-values").setMinSize(0)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    static final AttributeDefinition[] IDENTITY_REALM_ATTRIBUTES = new AttributeDefinition[]{IDENTITY, ATTRIBUTE_NAME, ATTRIBUTE_VALUES};

    RealmDefinitions() {
    }

    static ResourceDefinition getIdentityRealmDefinition() {
        TrivialAddHandler<SecurityRealm> add = new TrivialAddHandler<SecurityRealm>(SecurityRealm.class, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SecurityRealm> getValueSupplier(ServiceBuilder<SecurityRealm> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String identity = IDENTITY.resolveModelAttribute(context, model).asString();
                String attributeName = ATTRIBUTE_NAME.resolveModelAttribute(context, model).asStringOrNull();
                List attributeValues = ATTRIBUTE_VALUES.unwrap((ExpressionResolver)context, model);
                return () -> {
                    Map<Object, Object> attributesMap = attributeName != null ? Collections.singletonMap(attributeName, Collections.unmodifiableList(attributeValues)) : Collections.emptyMap();
                    Map<String, SimpleRealmEntry> realmMap = Collections.singletonMap(identity, new SimpleRealmEntry(Collections.emptyList(), (Attributes)new MapAttributes(attributesMap)));
                    SimpleMapBackedSecurityRealm securityRealm = new SimpleMapBackedSecurityRealm();
                    securityRealm.setPasswordMap(realmMap);
                    return securityRealm;
                };
            }
        };
        return new TrivialResourceDefinition("identity-realm", add, IDENTITY_REALM_ATTRIBUTES, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);
    }
}

