/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.httpclient.common.HttpServiceConfig;

public class RemoteHttpInvokerService
implements Service<PathHandler> {
    private static final String COMMON_PATH = "/common";
    private static final String AFFINITY_PATH = "/affinity";
    private final PathHandler pathHandler = new PathHandler();

    public void start(StartContext context) throws StartException {
        this.pathHandler.clearPaths();
        this.pathHandler.addPrefixPath(COMMON_PATH, this.getAffinityServiceHandler());
    }

    private HttpHandler getAffinityServiceHandler() {
        PathHandler wrappedHandler = new PathHandler();
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        wrappedHandler.addPrefixPath(AFFINITY_PATH, exchange -> {
            String resolved = exchange.getResolvedPath();
            int index = resolved.lastIndexOf(COMMON_PATH);
            if (index > 0) {
                resolved = resolved.substring(0, index);
            }
            exchange.getResponseCookies().put("JSESSIONID", new CookieImpl("JSESSIONID", generator.createSessionId()).setPath(resolved));
        });
        return HttpServiceConfig.getInstance().wrap((HttpHandler)wrappedHandler);
    }

    public void stop(StopContext context) {
        this.pathHandler.clearPaths();
    }

    public PathHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this.pathHandler;
    }
}

