/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import java.util.function.BiFunction;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.security.http.util.sso.SingleSignOnConfiguration;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

abstract class SingleSignOnDefinition
implements ChildResourceDefinitionRegistrar,
ResourceModelResolver<SingleSignOnConfiguration>,
ResourceServiceConfigurator {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"setting", (String)"single-sign-on");
    private final BiFunction<ResourceRegistration, ResourceDescriptionResolver, ResourceDefinition.Builder> builderFactory;
    private final BiFunction<ResourceDescriptor.Builder, ResourceServiceConfigurator, ResourceDescriptor.Builder> configurator;

    SingleSignOnDefinition(BiFunction<ResourceRegistration, ResourceDescriptionResolver, ResourceDefinition.Builder> builderFactory, BiFunction<ResourceDescriptor.Builder, ResourceServiceConfigurator, ResourceDescriptor.Builder> configurator) {
        this.builderFactory = builderFactory;
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)this.configurator.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)UndertowExtension.getResolver(PATH_ELEMENT.getValue())), this).provideAttributes(EnumSet.allOf(Attribute.class))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(this.builderFactory.apply(ResourceRegistration.of((PathElement)PATH_ELEMENT), descriptor.getResourceDescriptionResolver()).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public SingleSignOnConfiguration resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String cookieName = Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, model).asString();
        String domain = Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String path = Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, model).asString();
        boolean httpOnly = Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        boolean secure = Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        return new SingleSignOnConfiguration(cookieName, domain, path, httpOnly, secure);
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        DOMAIN("domain", ModelType.STRING, null),
        PATH("path", ModelType.STRING, new ModelNode("/")),
        HTTP_ONLY("http-only", ModelType.BOOLEAN, ModelNode.FALSE),
        SECURE("secure", ModelType.BOOLEAN, ModelNode.FALSE),
        COOKIE_NAME("cookie-name", ModelType.STRING, new ModelNode("JSESSIONIDSSO"));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setAllowExpression(true)).setDefaultValue(defaultValue)).setRestartAllServices()).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

