/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.undertow.deployment.ConfiguredHandlerWrapper;
import org.wildfly.extension.undertow.filters.PredicateHandlerWrapper;
import org.wildfly.extension.undertow.filters.SimpleFilterDefinition;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class CustomFilterDefinition
extends SimpleFilterDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"custom-filter");
    public static final AttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class-name", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final PropertiesAttributeDefinition PARAMETERS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("parameters", true).setRequired(false)).setAllowExpression(true)).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(null, "param", false))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, "param", false))).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(CLASS_NAME, MODULE, PARAMETERS);

    CustomFilterDefinition() {
        super(PATH_ELEMENT, CustomFilterDefinition::createHandlerWrapper);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static PredicateHandlerWrapper createHandlerWrapper(OperationContext context, ModelNode model) throws OperationFailedException {
        final String className = CLASS_NAME.resolveModelAttribute(context, model).asString();
        final String moduleName = MODULE.resolveModelAttribute(context, model).asString();
        final Map parameters = PARAMETERS.unwrap((ExpressionResolver)context, model);
        UndertowLogger.ROOT_LOGGER.debugf("Creating http handler %s from module %s with parameters %s", className, moduleName, parameters);
        return PredicateHandlerWrapper.filter(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                Class<?> handlerClass = CustomFilterDefinition.getHandlerClass(className, moduleName);
                return new ConfiguredHandlerWrapper(handlerClass, parameters).wrap(handler);
            }
        });
    }

    private static Class<?> getHandlerClass(String className, String moduleName) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        try {
            Module filterModule = moduleLoader.loadModule(moduleName);
            return filterModule.getClassLoader().loadClassLocal(className);
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            throw UndertowLogger.ROOT_LOGGER.couldNotLoadHandlerFromModule(className, moduleName, (Exception)e);
        }
    }
}

