/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.deployment.processors.StartupAwaitInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

public class StartupAwaitDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final Set<MethodInterfaceType> INTFS = EnumSet.of(MethodInterfaceType.MessageEndpoint, MethodInterfaceType.Remote, MethodInterfaceType.ServiceEndpoint, MethodInterfaceType.Local);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof EJBComponentDescription)) continue;
            component.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) {
                    StartupCountdown countdown = (StartupCountdown)context.getDeploymentUnit().getAttachment(Attachments.STARTUP_COUNTDOWN);
                    for (ViewConfiguration view : configuration.getViews()) {
                        EJBViewConfiguration ejbView = (EJBViewConfiguration)view;
                        if (!INTFS.contains(ejbView.getMethodIntf())) continue;
                        ejbView.addViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new StartupAwaitInterceptor(countdown)), 584);
                    }
                }
            });
        }
    }
}

