/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimer;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.ejb.timer.TimeoutListener;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;

public class DistributableTimeoutListener<I>
implements TimeoutListener<I> {
    private final TimedObjectInvoker invoker;
    private final TimerSynchronizationFactory<I> synchronizationFactory;

    public DistributableTimeoutListener(TimedObjectInvoker invoker, TimerSynchronizationFactory<I> synchronizationFactory) {
        this.invoker = invoker;
        this.synchronizationFactory = synchronizationFactory;
    }

    public void timeout(TimerManager<I> manager, Timer<I> timer) throws ExecutionException {
        try (Batch batch = (Batch)manager.getBatchFactory().get();
             BatchContext context = batch.suspendWithContext();){
            DistributableTimer<I> managedTimer = new DistributableTimer<I>(manager, timer, (SuspendedBatch)context.get(), this.invoker, this.synchronizationFactory);
            try {
                DistributableTimeoutListener.invoke(managedTimer);
            }
            catch (ExecutionException e) {
                EjbLogger.EJB3_TIMER_LOGGER.errorInvokeTimeout(managedTimer, e);
                EjbLogger.EJB3_TIMER_LOGGER.timerRetried(managedTimer);
                DistributableTimeoutListener.invoke(managedTimer);
            }
        }
    }

    private static void invoke(ManagedTimer timer) throws ExecutionException {
        try {
            timer.invoke();
        }
        catch (EJBComponentUnavailableException e) {
            throw new RejectedExecutionException((Throwable)((Object)e));
        }
        catch (Throwable e) {
            throw new ExecutionException(e);
        }
    }
}

