/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.json.JsonObject;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import java.util.Objects;
import org.glassfish.soteria.mechanisms.openid.domain.AccessTokenImpl;
import org.glassfish.soteria.mechanisms.openid.domain.IdentityTokenImpl;

public class OpenIdCredential
implements Credential {
    private final HttpMessageContext httpContext;
    private final IdentityTokenImpl identityToken;
    private final AccessToken accessToken;

    public OpenIdCredential(JsonObject tokensObject, HttpMessageContext httpContext, long tokenMinValidity) {
        this.httpContext = httpContext;
        this.identityToken = new IdentityTokenImpl(tokensObject.getString("id_token"), tokenMinValidity);
        String accessTokenString = tokensObject.getString("access_token", null);
        Long expiresIn = null;
        if (Objects.nonNull(tokensObject.getJsonNumber("expires_in"))) {
            expiresIn = tokensObject.getJsonNumber("expires_in").longValue();
        }
        String tokenType = tokensObject.getString("token_type", null);
        String scopeString = tokensObject.getString("scope", null);
        this.accessToken = Objects.nonNull(accessTokenString) ? new AccessTokenImpl(tokenType, accessTokenString, expiresIn, scopeString, tokenMinValidity) : null;
    }

    IdentityTokenImpl getIdentityTokenImpl() {
        return this.identityToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public HttpMessageContext getHttpContext() {
        return this.httpContext;
    }
}

